/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.core.remote.grpc.GrpcServerConstants;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamHelper;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelHelper;
import io.grpc.netty.shaded.io.netty.channel.Channel;

public class GrpcConnectionInterceptor
implements ServerInterceptor {
    public <T, S> ServerCall.Listener<T> interceptCall(ServerCall<T, S> call, Metadata headers, ServerCallHandler<T, S> next) {
        Context ctx = Context.current().withValue(GrpcServerConstants.CONTEXT_KEY_CONN_ID, (Object)((String)call.getAttributes().get(GrpcServerConstants.ATTR_TRANS_KEY_CONN_ID))).withValue(GrpcServerConstants.CONTEXT_KEY_CONN_REMOTE_IP, (Object)((String)call.getAttributes().get(GrpcServerConstants.ATTR_TRANS_KEY_REMOTE_IP))).withValue(GrpcServerConstants.CONTEXT_KEY_CONN_REMOTE_PORT, (Object)((Integer)call.getAttributes().get(GrpcServerConstants.ATTR_TRANS_KEY_REMOTE_PORT))).withValue(GrpcServerConstants.CONTEXT_KEY_CONN_LOCAL_PORT, (Object)((Integer)call.getAttributes().get(GrpcServerConstants.ATTR_TRANS_KEY_LOCAL_PORT)));
        if ("BiRequestStream".equals(call.getMethodDescriptor().getServiceName())) {
            Channel internalChannel = this.getInternalChannel(call);
            ctx = ctx.withValue(GrpcServerConstants.CONTEXT_KEY_CHANNEL, (Object)internalChannel);
        }
        return Contexts.interceptCall((Context)ctx, call, (Metadata)headers, next);
    }

    private Channel getInternalChannel(ServerCall serverCall) {
        ServerStream serverStream = ServerStreamHelper.getServerStream((ServerCall)serverCall);
        return NettyChannelHelper.getChannel(serverStream);
    }
}

