/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.monitor;

import com.alibaba.nacos.core.monitor.NacosMeterRegistryCenter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class MetricsMonitor {
    private static final String METER_REGISTRY = "CORE_STABLE_REGISTRY";
    private static final DistributionSummary RAFT_READ_INDEX_FAILED;
    private static final DistributionSummary RAFT_FROM_LEADER;
    private static final Timer RAFT_APPLY_LOG_TIMER;
    private static final Timer RAFT_APPLY_READ_TIMER;
    private static AtomicInteger longConnection;

    public static AtomicInteger getLongConnectionMonitor() {
        return longConnection;
    }

    public static void raftReadIndexFailed() {
        RAFT_READ_INDEX_FAILED.record(1.0);
    }

    public static void raftReadFromLeader() {
        RAFT_FROM_LEADER.record(1.0);
    }

    public static Timer getRaftApplyLogTimer() {
        return RAFT_APPLY_LOG_TIMER;
    }

    public static Timer getRaftApplyReadTimer() {
        return RAFT_APPLY_READ_TIMER;
    }

    public static DistributionSummary getRaftReadIndexFailed() {
        return RAFT_READ_INDEX_FAILED;
    }

    public static DistributionSummary getRaftFromLeader() {
        return RAFT_FROM_LEADER;
    }

    static {
        longConnection = new AtomicInteger();
        ImmutableTag immutableTag = new ImmutableTag("module", "core");
        ArrayList<Object> tags = new ArrayList<Tag>();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "raft_read_index_failed"));
        RAFT_READ_INDEX_FAILED = NacosMeterRegistryCenter.summary(METER_REGISTRY, "nacos_monitor", tags);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("name", "raft_read_from_leader"));
        RAFT_FROM_LEADER = NacosMeterRegistryCenter.summary(METER_REGISTRY, "nacos_monitor", tags);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("name", "raft_apply_log_timer"));
        RAFT_APPLY_LOG_TIMER = NacosMeterRegistryCenter.timer(METER_REGISTRY, "nacos_monitor", tags);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("name", "raft_apply_read_timer"));
        RAFT_APPLY_READ_TIMER = NacosMeterRegistryCenter.timer(METER_REGISTRY, "nacos_monitor", tags);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("name", "longConnection"));
        NacosMeterRegistryCenter.gauge(METER_REGISTRY, "nacos_monitor", tags, longConnection);
    }
}

