/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.version;

import io.spring.initializr.generator.version.Version;
import org.springframework.util.Assert;

public class VersionRange {
    private final Version lowerVersion;
    private final boolean lowerInclusive;
    private final Version higherVersion;
    private final boolean higherInclusive;

    protected VersionRange(Version lowerVersion, boolean lowerInclusive, Version higherVersion, boolean higherInclusive) {
        this.lowerVersion = lowerVersion;
        this.lowerInclusive = lowerInclusive;
        this.higherVersion = higherVersion;
        this.higherInclusive = higherInclusive;
    }

    public VersionRange(Version startingVersion) {
        this(startingVersion, true, null, false);
    }

    public boolean match(Version version) {
        Assert.notNull((Object)version, (String)"Version must not be null");
        int lower = this.lowerVersion.compareTo(version);
        if (lower > 0) {
            return false;
        }
        if (!this.lowerInclusive && lower == 0) {
            return false;
        }
        if (this.higherVersion != null) {
            int higher = this.higherVersion.compareTo(version);
            if (higher < 0) {
                return false;
            }
            if (!this.higherInclusive && higher == 0) {
                return false;
            }
        }
        return true;
    }

    public VersionRange format(Version.Format format) {
        Version lower = this.lowerVersion.format(format);
        Version higher = this.higherVersion != null ? this.higherVersion.format(format) : null;
        return new VersionRange(lower, this.lowerInclusive, higher, this.higherInclusive);
    }

    public Version getLowerVersion() {
        return this.lowerVersion;
    }

    public boolean isLowerInclusive() {
        return this.lowerInclusive;
    }

    public Version getHigherVersion() {
        return this.higherVersion;
    }

    public boolean isHigherInclusive() {
        return this.higherInclusive;
    }

    public String toRangeString() {
        StringBuilder sb = new StringBuilder();
        if (this.lowerVersion == null && this.higherVersion == null) {
            return "";
        }
        if (this.higherVersion != null) {
            sb.append(this.lowerInclusive ? "[" : "(").append(this.lowerVersion).append(",").append(this.higherVersion).append(this.higherInclusive ? "]" : ")");
        } else {
            sb.append(this.lowerVersion);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        if (this.higherInclusive != other.higherInclusive) {
            return false;
        }
        if (this.higherVersion == null ? other.higherVersion != null : !this.higherVersion.equals(other.higherVersion)) {
            return false;
        }
        if (this.lowerInclusive != other.lowerInclusive) {
            return false;
        }
        return !(this.lowerVersion == null ? other.lowerVersion != null : !this.lowerVersion.equals(other.lowerVersion));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.higherInclusive ? 1231 : 1237);
        result = 31 * result + (this.higherVersion == null ? 0 : this.higherVersion.hashCode());
        result = 31 * result + (this.lowerInclusive ? 1231 : 1237);
        result = 31 * result + (this.lowerVersion == null ? 0 : this.lowerVersion.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.lowerVersion != null) {
            sb.append(this.lowerInclusive ? ">=" : ">").append(this.lowerVersion);
        }
        if (this.higherVersion != null) {
            sb.append(" and ").append(this.higherInclusive ? "<=" : "<").append(this.higherVersion);
        }
        return sb.toString();
    }
}

