/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.version;

import io.spring.initializr.generator.version.InvalidVersionException;
import io.spring.initializr.generator.version.VersionParser;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class Version
implements Serializable,
Comparable<Version> {
    private static final VersionQualifierComparator qualifierComparator = new VersionQualifierComparator();
    private static final VersionParser parser = new VersionParser(Collections.emptyList());
    private final Integer major;
    private final Integer minor;
    private final Integer patch;
    private final Qualifier qualifier;
    private final Format format;

    public Version(Integer major, Integer minor, Integer patch, Qualifier qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
        this.format = Version.determineFormat(qualifier);
    }

    private static Format determineFormat(Qualifier qualifier) {
        if (qualifier == null) {
            return Format.V2;
        }
        return qualifier.getSeparator().equals(".") ? Format.V1 : Format.V2;
    }

    public Version format(Format format) {
        Assert.notNull((Object)((Object)format), () -> "Format must not be null");
        if (this.format == format) {
            return this;
        }
        Qualifier qualifier = format == Format.V1 ? this.formatQualifier(".", this::toV1Qualifier) : this.formatQualifier("-", this::toV2Qualifier);
        return new Version(this.major, this.minor, this.patch, qualifier);
    }

    private Qualifier formatQualifier(String newSeparator, Function<String, String> idTransformer) {
        String originalQualifier = this.qualifier != null ? this.qualifier.getId() : null;
        String newId = idTransformer.apply(originalQualifier);
        if (newId != null) {
            return new Qualifier(newId, this.qualifier != null ? this.qualifier.getVersion() : null, newSeparator);
        }
        return null;
    }

    private String toV1Qualifier(String id) {
        if ("SNAPSHOT".equals(id)) {
            return "BUILD-SNAPSHOT";
        }
        if (id == null) {
            return "RELEASE";
        }
        return id;
    }

    private String toV2Qualifier(String id) {
        if ("BUILD-SNAPSHOT".equals(id)) {
            return "SNAPSHOT";
        }
        if ("RELEASE".equals(id)) {
            return null;
        }
        return id;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public Format getFormat() {
        return this.format;
    }

    public static Version parse(String text) {
        return parser.parse(text);
    }

    public static Version safeParse(String text) {
        try {
            return Version.parse(text);
        }
        catch (InvalidVersionException ex) {
            return null;
        }
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            return 1;
        }
        int majorDiff = Version.safeCompare(this.major, other.major);
        if (majorDiff != 0) {
            return majorDiff;
        }
        int minorDiff = Version.safeCompare(this.minor, other.minor);
        if (minorDiff != 0) {
            return minorDiff;
        }
        int patch = Version.safeCompare(this.patch, other.patch);
        if (patch != 0) {
            return patch;
        }
        return qualifierComparator.compare(this.qualifier, other.qualifier);
    }

    private static int safeCompare(Integer first, Integer second) {
        Integer firstIndex = first != null ? first : 0;
        Integer secondIndex = second != null ? second : 0;
        return firstIndex.compareTo(secondIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major == null ? other.major != null : !this.major.equals(other.major)) {
            return false;
        }
        if (this.minor == null ? other.minor != null : !this.minor.equals(other.minor)) {
            return false;
        }
        if (this.patch == null ? other.patch != null : !this.patch.equals(other.patch)) {
            return false;
        }
        return !(this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.major == null ? 0 : this.major.hashCode());
        result = 31 * result + (this.minor == null ? 0 : this.minor.hashCode());
        result = 31 * result + (this.patch == null ? 0 : this.patch.hashCode());
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.major).append(".").append(this.minor).append(".").append(this.patch);
        if (this.qualifier != null) {
            sb.append(this.qualifier.getSeparator()).append(this.qualifier.getId());
            if (this.qualifier.getVersion() != null) {
                sb.append(this.qualifier.getVersion());
            }
        }
        return sb.toString();
    }

    private static class VersionQualifierComparator
    implements Comparator<Qualifier> {
        static final String RELEASE = "RELEASE";
        static final String BUILD_SNAPSHOT = "BUILD-SNAPSHOT";
        static final String SNAPSHOT = "SNAPSHOT";
        static final String MILESTONE = "M";
        static final String RC = "RC";
        static final List<String> KNOWN_QUALIFIERS = Arrays.asList("M", "RC", "BUILD-SNAPSHOT", "SNAPSHOT", "RELEASE");

        private VersionQualifierComparator() {
        }

        @Override
        public int compare(Qualifier o1, Qualifier o2) {
            Qualifier first = o1 != null ? o1 : new Qualifier(RELEASE);
            Qualifier second = o2 != null ? o2 : new Qualifier(RELEASE);
            int qualifier = VersionQualifierComparator.compareQualifier(first, second);
            return qualifier != 0 ? qualifier : VersionQualifierComparator.compareQualifierVersion(first, second);
        }

        private static int compareQualifierVersion(Qualifier first, Qualifier second) {
            Integer firstVersion = first.getVersion() != null ? first.getVersion() : 0;
            Integer secondVersion = second.getVersion() != null ? second.getVersion() : 0;
            return firstVersion.compareTo(secondVersion);
        }

        private static int compareQualifier(Qualifier first, Qualifier second) {
            int firstIndex = VersionQualifierComparator.getQualifierIndex(first.getId());
            int secondIndex = VersionQualifierComparator.getQualifierIndex(second.getId());
            if (firstIndex == -1 && secondIndex == -1) {
                return first.getId().compareTo(second.getId());
            }
            return Integer.compare(firstIndex, secondIndex);
        }

        private static int getQualifierIndex(String qualifier) {
            return StringUtils.hasText((String)qualifier) ? KNOWN_QUALIFIERS.indexOf(qualifier) : 0;
        }
    }

    public static enum Format {
        V1,
        V2;

    }

    public static class Qualifier
    implements Serializable {
        private final String id;
        private final Integer version;
        private final String separator;

        public Qualifier(String id) {
            this(id, null, ".");
        }

        public Qualifier(String id, Integer version, String separator) {
            this.id = id;
            this.version = version;
            this.separator = separator;
        }

        public String getId() {
            return this.id;
        }

        public Integer getVersion() {
            return this.version;
        }

        public String getSeparator() {
            return this.separator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Qualifier qualifier = (Qualifier)o;
            return this.id.equals(qualifier.id) && Objects.equals(this.version, qualifier.version) && Objects.equals(this.separator, qualifier.separator);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version, this.separator);
        }

        public String toString() {
            return new StringJoiner(", ", Qualifier.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("version=" + this.version).add("separator='" + this.separator + "'").toString();
        }
    }
}

