/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.language.kotlin;

import io.spring.initializr.generator.io.IndentingWriter;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.language.Annotatable;
import io.spring.initializr.generator.language.Annotation;
import io.spring.initializr.generator.language.Parameter;
import io.spring.initializr.generator.language.SourceCodeWriter;
import io.spring.initializr.generator.language.SourceStructure;
import io.spring.initializr.generator.language.kotlin.KotlinCompilationUnit;
import io.spring.initializr.generator.language.kotlin.KotlinExpression;
import io.spring.initializr.generator.language.kotlin.KotlinExpressionStatement;
import io.spring.initializr.generator.language.kotlin.KotlinFunctionDeclaration;
import io.spring.initializr.generator.language.kotlin.KotlinFunctionInvocation;
import io.spring.initializr.generator.language.kotlin.KotlinModifier;
import io.spring.initializr.generator.language.kotlin.KotlinPropertyDeclaration;
import io.spring.initializr.generator.language.kotlin.KotlinReifiedFunctionInvocation;
import io.spring.initializr.generator.language.kotlin.KotlinReturnStatement;
import io.spring.initializr.generator.language.kotlin.KotlinSourceCode;
import io.spring.initializr.generator.language.kotlin.KotlinStatement;
import io.spring.initializr.generator.language.kotlin.KotlinTypeDeclaration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KotlinSourceCodeWriter
implements SourceCodeWriter<KotlinSourceCode> {
    private final IndentingWriterFactory indentingWriterFactory;

    public KotlinSourceCodeWriter(IndentingWriterFactory indentingWriterFactory) {
        this.indentingWriterFactory = indentingWriterFactory;
    }

    @Override
    public void writeTo(SourceStructure structure, KotlinSourceCode sourceCode) throws IOException {
        for (KotlinCompilationUnit compilationUnit : sourceCode.getCompilationUnits()) {
            this.writeTo(structure, compilationUnit);
        }
    }

    @Override
    private void writeTo(SourceStructure structure, KotlinCompilationUnit compilationUnit) throws IOException {
        Path output = structure.createSourceFile(compilationUnit.getPackageName(), compilationUnit.getName());
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        try (IndentingWriter writer = this.indentingWriterFactory.createIndentingWriter("kotlin", Files.newBufferedWriter(output, new OpenOption[0]));){
            writer.println("package " + compilationUnit.getPackageName());
            writer.println();
            Set<String> imports = this.determineImports(compilationUnit);
            if (!imports.isEmpty()) {
                for (String importedType : imports) {
                    writer.println("import " + importedType);
                }
                writer.println();
            }
            for (KotlinTypeDeclaration type : compilationUnit.getTypeDeclarations()) {
                boolean hasDeclarations;
                this.writeAnnotations(writer, type);
                this.writeModifiers(writer, type.getModifiers());
                writer.print("class " + type.getName());
                if (type.getExtends() != null) {
                    writer.print(" : " + this.getUnqualifiedName(type.getExtends()) + "()");
                }
                List<KotlinPropertyDeclaration> propertyDeclarations = type.getPropertyDeclarations();
                List<KotlinFunctionDeclaration> functionDeclarations = type.getFunctionDeclarations();
                boolean bl = hasDeclarations = !propertyDeclarations.isEmpty() || !functionDeclarations.isEmpty();
                if (hasDeclarations) {
                    writer.println(" {");
                }
                if (!propertyDeclarations.isEmpty()) {
                    writer.indented(() -> {
                        for (KotlinPropertyDeclaration propertyDeclaration : propertyDeclarations) {
                            this.writeProperty(writer, propertyDeclaration);
                        }
                    });
                }
                if (!functionDeclarations.isEmpty()) {
                    writer.indented(() -> {
                        for (KotlinFunctionDeclaration functionDeclaration : functionDeclarations) {
                            this.writeFunction(writer, functionDeclaration);
                        }
                    });
                    writer.println();
                } else {
                    writer.println("");
                }
                if (!hasDeclarations) continue;
                writer.println("}");
            }
            List<KotlinFunctionDeclaration> topLevelFunctions = compilationUnit.getTopLevelFunctions();
            if (!topLevelFunctions.isEmpty()) {
                for (KotlinFunctionDeclaration topLevelFunction : topLevelFunctions) {
                    this.writeFunction(writer, topLevelFunction);
                }
            }
        }
    }

    private void writeProperty(IndentingWriter writer, KotlinPropertyDeclaration propertyDeclaration) {
        writer.println();
        this.writeModifiers(writer, propertyDeclaration.getModifiers());
        if (propertyDeclaration.isVal()) {
            writer.print("val ");
        } else {
            writer.print("var ");
        }
        writer.print(propertyDeclaration.getName());
        if (propertyDeclaration.getReturnType() != null) {
            writer.print(": " + this.getUnqualifiedName(propertyDeclaration.getReturnType()));
        }
        if (propertyDeclaration.getValueExpression() != null) {
            writer.print(" = ");
            this.writeExpression(writer, propertyDeclaration.getValueExpression().getExpression());
        }
        if (propertyDeclaration.getGetter() != null) {
            writer.println();
            writer.indented(() -> this.writeAccessor(writer, "get", propertyDeclaration.getGetter()));
        }
        if (propertyDeclaration.getSetter() != null) {
            writer.println();
            writer.indented(() -> this.writeAccessor(writer, "set", propertyDeclaration.getSetter()));
        }
        writer.println();
    }

    private void writeAccessor(IndentingWriter writer, String accessorName, KotlinPropertyDeclaration.Accessor accessor) {
        if (!accessor.getAnnotations().isEmpty()) {
            for (Annotation annotation : accessor.getAnnotations()) {
                this.writeAnnotation(writer, annotation, false);
            }
        }
        writer.print(accessorName);
        if (!accessor.isEmptyBody()) {
            writer.print("() = ");
            this.writeExpression(writer, accessor.getBody().getExpression());
        }
    }

    private void writeFunction(IndentingWriter writer, KotlinFunctionDeclaration functionDeclaration) {
        writer.println();
        this.writeAnnotations(writer, functionDeclaration);
        this.writeModifiers(writer, functionDeclaration.getModifiers());
        writer.print("fun ");
        writer.print(functionDeclaration.getName() + "(");
        List<Parameter> parameters = functionDeclaration.getParameters();
        if (!parameters.isEmpty()) {
            writer.print(parameters.stream().map(parameter -> parameter.getName() + ": " + this.getUnqualifiedName(parameter.getType())).collect(Collectors.joining(", ")));
        }
        writer.print(")");
        if (functionDeclaration.getReturnType() != null) {
            writer.print(": " + this.getUnqualifiedName(functionDeclaration.getReturnType()));
        }
        writer.println(" {");
        List<KotlinStatement> statements = functionDeclaration.getStatements();
        writer.indented(() -> {
            for (KotlinStatement statement : statements) {
                if (statement instanceof KotlinExpressionStatement) {
                    this.writeExpression(writer, ((KotlinExpressionStatement)statement).getExpression());
                } else if (statement instanceof KotlinReturnStatement) {
                    writer.print("return ");
                    this.writeExpression(writer, ((KotlinReturnStatement)statement).getExpression());
                }
                writer.println("");
            }
        });
        writer.println("}");
    }

    private void writeAnnotations(IndentingWriter writer, Annotatable annotatable) {
        for (Annotation annotation : annotatable.getAnnotations()) {
            this.writeAnnotation(writer, annotation, true);
        }
    }

    private void writeAnnotation(IndentingWriter writer, Annotation annotation, boolean newLine) {
        writer.print("@" + this.getUnqualifiedName(annotation.getName()));
        List<Annotation.Attribute> attributes = annotation.getAttributes();
        if (!attributes.isEmpty()) {
            writer.print("(");
            if (attributes.size() == 1 && attributes.get(0).getName().equals("value")) {
                writer.print(this.formatAnnotationAttribute(attributes.get(0)));
            } else {
                writer.print(attributes.stream().map(attribute -> attribute.getName() + " = " + this.formatAnnotationAttribute((Annotation.Attribute)attribute)).collect(Collectors.joining(", ")));
            }
            writer.print(")");
        }
        if (newLine) {
            writer.println();
        } else {
            writer.print(" ");
        }
    }

    private String formatAnnotationAttribute(Annotation.Attribute attribute) {
        List<String> values = attribute.getValues();
        if (attribute.getType().equals(Class.class)) {
            return this.formatValues(values, value -> String.format("%s::class", this.getUnqualifiedName((String)value)));
        }
        if (Enum.class.isAssignableFrom(attribute.getType())) {
            return this.formatValues(values, value -> {
                String enumValue = value.substring(value.lastIndexOf(".") + 1);
                String enumClass = value.substring(0, value.lastIndexOf("."));
                return String.format("%s.%s", this.getUnqualifiedName(enumClass), enumValue);
            });
        }
        if (attribute.getType().equals(String.class)) {
            return this.formatValues(values, value -> String.format("\"%s\"", value));
        }
        return this.formatValues(values, value -> String.format("%s", value));
    }

    private String formatValues(List<String> values, Function<String, String> formatter) {
        String result = values.stream().map(formatter).collect(Collectors.joining(", "));
        return values.size() > 1 ? "[" + result + "]" : result;
    }

    private void writeModifiers(IndentingWriter writer, List<KotlinModifier> declaredModifiers) {
        String modifiers = declaredModifiers.stream().filter(entry -> !entry.equals((Object)KotlinModifier.PUBLIC)).sorted().map(entry -> entry.toString().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" "));
        if (!modifiers.isEmpty()) {
            writer.print(modifiers);
            writer.print(" ");
        }
    }

    private void writeExpression(IndentingWriter writer, KotlinExpression expression) {
        if (expression instanceof KotlinFunctionInvocation) {
            this.writeFunctionInvocation(writer, (KotlinFunctionInvocation)expression);
        } else if (expression instanceof KotlinReifiedFunctionInvocation) {
            this.writeReifiedFunctionInvocation(writer, (KotlinReifiedFunctionInvocation)expression);
        } else if (expression != null) {
            writer.print(expression.toString());
        }
    }

    private void writeFunctionInvocation(IndentingWriter writer, KotlinFunctionInvocation functionInvocation) {
        writer.print(this.getUnqualifiedName(functionInvocation.getTarget()) + "." + functionInvocation.getName() + "(" + String.join((CharSequence)", ", functionInvocation.getArguments()) + ")");
    }

    private void writeReifiedFunctionInvocation(IndentingWriter writer, KotlinReifiedFunctionInvocation functionInvocation) {
        writer.print(this.getUnqualifiedName(functionInvocation.getName()) + "<" + this.getUnqualifiedName(functionInvocation.getTargetClass()) + ">(" + String.join((CharSequence)", ", functionInvocation.getArguments()) + ")");
    }

    private Set<String> determineImports(KotlinCompilationUnit compilationUnit) {
        ArrayList<String> imports = new ArrayList<String>();
        for (KotlinTypeDeclaration typeDeclaration : compilationUnit.getTypeDeclarations()) {
            if (this.requiresImport(typeDeclaration.getExtends())) {
                imports.add(typeDeclaration.getExtends());
            }
            imports.addAll(this.getRequiredImports(typeDeclaration.getAnnotations(), this::determineImports));
            typeDeclaration.getPropertyDeclarations().forEach(propertyDeclaration -> imports.addAll(this.determinePropertyImports((KotlinPropertyDeclaration)propertyDeclaration)));
            typeDeclaration.getFunctionDeclarations().forEach(functionDeclaration -> imports.addAll(this.determineFunctionImports((KotlinFunctionDeclaration)functionDeclaration)));
        }
        compilationUnit.getTopLevelFunctions().forEach(functionDeclaration -> imports.addAll(this.determineFunctionImports((KotlinFunctionDeclaration)functionDeclaration)));
        Collections.sort(imports);
        return new LinkedHashSet<String>(imports);
    }

    private Set<String> determinePropertyImports(KotlinPropertyDeclaration propertyDeclaration) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        if (this.requiresImport(propertyDeclaration.getReturnType())) {
            imports.add(propertyDeclaration.getReturnType());
        }
        return imports;
    }

    private Set<String> determineFunctionImports(KotlinFunctionDeclaration functionDeclaration) {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        if (this.requiresImport(functionDeclaration.getReturnType())) {
            imports.add(functionDeclaration.getReturnType());
        }
        imports.addAll(this.getRequiredImports(functionDeclaration.getAnnotations(), this::determineImports));
        imports.addAll(this.getRequiredImports(functionDeclaration.getParameters(), (T parameter) -> Collections.singleton(parameter.getType())));
        imports.addAll(this.getRequiredImports(this.getKotlinExpressions(functionDeclaration).filter(KotlinFunctionInvocation.class::isInstance).map(KotlinFunctionInvocation.class::cast), (T invocation) -> Collections.singleton(invocation.getTarget())));
        imports.addAll(this.getRequiredImports(this.getKotlinExpressions(functionDeclaration).filter(KotlinReifiedFunctionInvocation.class::isInstance).map(KotlinReifiedFunctionInvocation.class::cast), (T invocation) -> Collections.singleton(invocation.getName())));
        return imports;
    }

    private Collection<String> determineImports(Annotation annotation) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(annotation.getName());
        annotation.getAttributes().forEach(attribute -> {
            if (attribute.getType() == Class.class) {
                imports.addAll(attribute.getValues());
            }
            if (Enum.class.isAssignableFrom(attribute.getType())) {
                imports.addAll(attribute.getValues().stream().map(value -> value.substring(0, value.lastIndexOf("."))).collect(Collectors.toList()));
            }
        });
        return imports;
    }

    private Stream<KotlinExpression> getKotlinExpressions(KotlinFunctionDeclaration functionDeclaration) {
        return functionDeclaration.getStatements().stream().filter(KotlinExpressionStatement.class::isInstance).map(KotlinExpressionStatement.class::cast).map(KotlinExpressionStatement::getExpression);
    }

    private <T> List<String> getRequiredImports(List<T> candidates, Function<T, Collection<String>> mapping) {
        return this.getRequiredImports(candidates.stream(), mapping);
    }

    private <T> List<String> getRequiredImports(Stream<T> candidates, Function<T, Collection<String>> mapping) {
        return candidates.map(mapping).flatMap(Collection::stream).filter(this::requiresImport).collect(Collectors.toList());
    }

    private String getUnqualifiedName(String name) {
        if (!name.contains(".")) {
            return name;
        }
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private boolean requiresImport(String name) {
        if (name == null || !name.contains(".")) {
            return false;
        }
        String packageName = name.substring(0, name.lastIndexOf(46));
        return !"java.lang".equals(packageName);
    }
}

