/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.maven;

import io.spring.initializr.generator.buildsystem.maven.MavenPlugin;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class MavenPluginContainer {
    private final Map<String, MavenPlugin.Builder> plugins = new LinkedHashMap<String, MavenPlugin.Builder>();

    public boolean isEmpty() {
        return this.plugins.isEmpty();
    }

    public boolean has(String groupId, String artifactId) {
        return this.plugins.containsKey(this.pluginKey(groupId, artifactId));
    }

    public Stream<MavenPlugin> values() {
        return this.plugins.values().stream().map(MavenPlugin.Builder::build);
    }

    public void add(String groupId, String artifactId) {
        this.addPlugin(groupId, artifactId);
    }

    public void add(String groupId, String artifactId, Consumer<MavenPlugin.Builder> plugin) {
        plugin.accept(this.addPlugin(groupId, artifactId));
    }

    private MavenPlugin.Builder addPlugin(String groupId, String artifactId) {
        return this.plugins.computeIfAbsent(this.pluginKey(groupId, artifactId), pluginId -> new MavenPlugin.Builder(groupId, artifactId));
    }

    public boolean remove(String groupId, String artifactId) {
        return this.plugins.remove(this.pluginKey(groupId, artifactId)) != null;
    }

    private String pluginKey(String groupId, String artifactId) {
        return String.format("%s:%s", groupId, artifactId);
    }
}

