/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.buildsystem.gradle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class GradleTask {
    private final String name;
    private final String type;
    private final Map<String, String> attributes;
    private final List<Invocation> invocations;
    private final Map<String, GradleTask> nested;

    protected GradleTask(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.attributes = Collections.unmodifiableMap(new LinkedHashMap(builder.attributes));
        this.invocations = Collections.unmodifiableList(new ArrayList(builder.invocations));
        this.nested = Collections.unmodifiableMap(GradleTask.resolve(builder.nested));
    }

    private static Map<String, GradleTask> resolve(Map<String, Builder> tasks) {
        LinkedHashMap<String, GradleTask> result = new LinkedHashMap<String, GradleTask>();
        tasks.forEach((name, builder) -> result.put((String)name, builder.build()));
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<Invocation> getInvocations() {
        return this.invocations;
    }

    public Map<String, GradleTask> getNested() {
        return this.nested;
    }

    public static class Invocation {
        private final String target;
        private final List<String> arguments;

        Invocation(String target, List<String> arguments) {
            this.target = target;
            this.arguments = arguments;
        }

        public String getTarget() {
            return this.target;
        }

        public List<String> getArguments() {
            return this.arguments;
        }
    }

    public static class Builder {
        private final String name;
        private final String type;
        private final Map<String, String> attributes = new LinkedHashMap<String, String>();
        private final List<Invocation> invocations = new ArrayList<Invocation>();
        private final Map<String, Builder> nested = new LinkedHashMap<String, Builder>();

        protected Builder(String name, String type) {
            this.name = name;
            this.type = type;
        }

        protected Builder(String name) {
            this(name, null);
        }

        public void attribute(String target, String value) {
            this.attributes.put(target, value);
        }

        public void invoke(String target, String ... arguments) {
            this.invocations.add(new Invocation(target, Arrays.asList(arguments)));
        }

        public void nested(String property, Consumer<Builder> customizer) {
            customizer.accept(this.nested.computeIfAbsent(property, name -> new Builder(property)));
        }

        public GradleTask build() {
            return new GradleTask(this);
        }
    }
}

