package io.smallrye.openapi.spring;

import java.util.Locale;
import java.io.Serializable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class SpringLogging_$logger implements SpringLogging, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SpringLogging_$logger.class.getName();
    public SpringLogging_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void ignoringAnnotation(final String className) {
        log.logf(FQCN, WARN, null, ignoringAnnotation$str(), className);
    }
    protected String ignoringAnnotation$str() {
        return "SROAP11000: Ignoring %s annotation that is not on a class";
    }
    @Override
    public final void processingController(final String className) {
        log.logf(FQCN, DEBUG, null, processingController$str(), className);
    }
    protected String processingController$str() {
        return "SROAP11001: Processing a Spring REST Controller class: %s";
    }
    @Override
    public final void processingMethod(final String methodName) {
        log.logf(FQCN, DEBUG, null, processingMethod$str(), methodName);
    }
    protected String processingMethod$str() {
        return "SROAP11002: Processing Spring method: %s";
    }
    @Override
    public final void missingPathSegment(final String segment) {
        log.logf(FQCN, WARN, null, missingPathSegment$str(), segment);
    }
    protected String missingPathSegment$str() {
        return "SROAP11003: Matrix parameter references missing path segment: %s";
    }
    @Override
    public final void invalidDefault(final String segment, final String primitive) {
        log.logf(FQCN, WARN, null, invalidDefault$str(), segment, primitive);
    }
    protected String invalidDefault$str() {
        return "SROAP11004: Value '%s' is not a valid %s default";
    }
}
