/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class FilterUtil {
    private FilterUtil() {
    }

    public static final OpenAPI applyFilter(OASFilter filter, OpenAPI model) {
        FilterUtil.filterComponents(filter, model.getComponents());
        if (model.getPaths() != null) {
            FilterUtil.filter(filter, model.getPaths().getPathItems(), FilterUtil::filterPathItem, arg_0 -> ((OASFilter)filter).filterPathItem(arg_0), arg_0 -> ((Paths)model.getPaths()).removePathItem(arg_0));
        }
        FilterUtil.filter(filter, model.getServers(), null, arg_0 -> ((OASFilter)filter).filterServer(arg_0), arg_0 -> ((OpenAPI)model).removeServer(arg_0));
        FilterUtil.filter(filter, model.getTags(), null, arg_0 -> ((OASFilter)filter).filterTag(arg_0), arg_0 -> ((OpenAPI)model).removeTag(arg_0));
        filter.filterOpenAPI(model);
        return model;
    }

    private static void filterComponents(OASFilter filter, Components model) {
        if (model != null) {
            FilterUtil.filter(filter, model.getCallbacks(), FilterUtil::filterCallback, arg_0 -> ((OASFilter)filter).filterCallback(arg_0), arg_0 -> ((Components)model).removeCallback(arg_0));
            FilterUtil.filter(filter, model.getHeaders(), FilterUtil::filterHeader, arg_0 -> ((OASFilter)filter).filterHeader(arg_0), arg_0 -> ((Components)model).removeHeader(arg_0));
            FilterUtil.filter(filter, model.getLinks(), FilterUtil::filterLink, arg_0 -> ((OASFilter)filter).filterLink(arg_0), arg_0 -> ((Components)model).removeLink(arg_0));
            FilterUtil.filter(filter, model.getParameters(), FilterUtil::filterParameter, arg_0 -> ((OASFilter)filter).filterParameter(arg_0), arg_0 -> ((Components)model).removeParameter(arg_0));
            FilterUtil.filter(filter, model.getRequestBodies(), FilterUtil::filterRequestBody, arg_0 -> ((OASFilter)filter).filterRequestBody(arg_0), arg_0 -> ((Components)model).removeRequestBody(arg_0));
            FilterUtil.filter(filter, model.getResponses(), FilterUtil::filterAPIResponse, arg_0 -> ((OASFilter)filter).filterAPIResponse(arg_0), arg_0 -> ((Components)model).removeResponse(arg_0));
            FilterUtil.filter(filter, model.getSchemas(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Components)model).removeSchema(arg_0));
            FilterUtil.filter(filter, model.getSecuritySchemes(), null, arg_0 -> ((OASFilter)filter).filterSecurityScheme(arg_0), arg_0 -> ((Components)model).removeSecurityScheme(arg_0));
        }
    }

    private static <K, V> void filter(OASFilter filter, Map<K, V> models, BiConsumer<OASFilter, V> contentFilter, UnaryOperator<V> modelFilter, Consumer<K> remover) {
        if (models != null) {
            for (Map.Entry entry : new LinkedHashSet<Map.Entry<K, V>>(models.entrySet())) {
                Object model = entry.getValue();
                if (contentFilter != null) {
                    contentFilter.accept(filter, model);
                }
                if (modelFilter.apply(model) != null) continue;
                remover.accept(entry.getKey());
            }
        }
    }

    private static <T> void filter(OASFilter filter, List<T> models, BiConsumer<OASFilter, T> contentFilter, UnaryOperator<T> modelFilter, Consumer<T> remover) {
        if (models != null) {
            for (T model : new ArrayList<T>(models)) {
                if (contentFilter != null) {
                    contentFilter.accept(filter, (OASFilter)model);
                }
                if (modelFilter.apply(model) != null) continue;
                remover.accept(model);
            }
        }
    }

    private static <T> void filter(OASFilter filter, T model, BiConsumer<OASFilter, T> contentFilter, UnaryOperator<T> modelFilter, Consumer<T> mutator) {
        if (model != null) {
            if (contentFilter != null) {
                contentFilter.accept(filter, (OASFilter)model);
            }
            mutator.accept(modelFilter.apply(model));
        }
    }

    private static void filterCallback(OASFilter filter, Callback model) {
        if (model != null) {
            ArrayList keys = new ArrayList(model.getPathItems().keySet());
            for (String key : keys) {
                PathItem childModel = model.getPathItem(key);
                FilterUtil.filterPathItem(filter, childModel);
                if (filter.filterPathItem(childModel) != null) continue;
                model.removePathItem(key);
            }
        }
    }

    private static void filterPathItem(OASFilter filter, PathItem model) {
        if (model != null) {
            FilterUtil.filter(filter, model.getParameters(), FilterUtil::filterParameter, arg_0 -> ((OASFilter)filter).filterParameter(arg_0), arg_0 -> ((PathItem)model).removeParameter(arg_0));
            FilterUtil.filterOperation(filter, model.getDELETE(), arg_0 -> ((PathItem)model).setDELETE(arg_0));
            FilterUtil.filterOperation(filter, model.getGET(), arg_0 -> ((PathItem)model).setGET(arg_0));
            FilterUtil.filterOperation(filter, model.getHEAD(), arg_0 -> ((PathItem)model).setHEAD(arg_0));
            FilterUtil.filterOperation(filter, model.getOPTIONS(), arg_0 -> ((PathItem)model).setOPTIONS(arg_0));
            FilterUtil.filterOperation(filter, model.getPATCH(), arg_0 -> ((PathItem)model).setPATCH(arg_0));
            FilterUtil.filterOperation(filter, model.getPOST(), arg_0 -> ((PathItem)model).setPOST(arg_0));
            FilterUtil.filterOperation(filter, model.getPUT(), arg_0 -> ((PathItem)model).setPUT(arg_0));
            FilterUtil.filterOperation(filter, model.getTRACE(), arg_0 -> ((PathItem)model).setTRACE(arg_0));
            FilterUtil.filter(filter, model.getServers(), null, arg_0 -> ((OASFilter)filter).filterServer(arg_0), arg_0 -> ((PathItem)model).removeServer(arg_0));
        }
    }

    private static void filterOperation(OASFilter filter, Operation model, Consumer<Operation> mutator) {
        if (model != null) {
            FilterUtil.filter(filter, model.getCallbacks(), FilterUtil::filterCallback, arg_0 -> ((OASFilter)filter).filterCallback(arg_0), arg_0 -> ((Operation)model).removeCallback(arg_0));
            FilterUtil.filter(filter, model.getParameters(), FilterUtil::filterParameter, arg_0 -> ((OASFilter)filter).filterParameter(arg_0), arg_0 -> ((Operation)model).removeParameter(arg_0));
            FilterUtil.filter(filter, model.getRequestBody(), FilterUtil::filterRequestBody, arg_0 -> ((OASFilter)filter).filterRequestBody(arg_0), arg_0 -> ((Operation)model).setRequestBody(arg_0));
            if (model.getResponses() != null) {
                APIResponses responses = model.getResponses();
                FilterUtil.filter(filter, responses.getAPIResponses(), FilterUtil::filterAPIResponse, arg_0 -> ((OASFilter)filter).filterAPIResponse(arg_0), arg_0 -> ((APIResponses)responses).removeAPIResponse(arg_0));
            }
            FilterUtil.filter(filter, model.getServers(), null, arg_0 -> ((OASFilter)filter).filterServer(arg_0), arg_0 -> ((Operation)model).removeServer(arg_0));
            mutator.accept(filter.filterOperation(model));
        }
    }

    private static void filterHeader(OASFilter filter, Header model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
            FilterUtil.filter(filter, model.getSchema(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Header)model).setSchema(arg_0));
        }
    }

    private static void filterContent(OASFilter filter, Content model) {
        if (model != null && model.getMediaTypes() != null) {
            ArrayList keys = new ArrayList(model.getMediaTypes().keySet());
            for (String key : keys) {
                MediaType childModel = model.getMediaType(key);
                FilterUtil.filterMediaType(filter, childModel);
            }
        }
    }

    private static void filterMediaType(OASFilter filter, MediaType model) {
        if (model != null) {
            FilterUtil.filterEncoding(filter, model.getEncoding());
            FilterUtil.filter(filter, model.getSchema(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((MediaType)model).setSchema(arg_0));
        }
    }

    private static void filterEncoding(OASFilter filter, Map<String, Encoding> models) {
        if (models != null) {
            ArrayList<String> keys = new ArrayList<String>(models.keySet());
            for (String key : keys) {
                Encoding model = models.get(key);
                FilterUtil.filterEncoding(filter, model);
            }
        }
    }

    private static void filterEncoding(OASFilter filter, Encoding model) {
        if (model != null) {
            FilterUtil.filter(filter, model.getHeaders(), FilterUtil::filterHeader, arg_0 -> ((OASFilter)filter).filterHeader(arg_0), arg_0 -> ((Encoding)model).removeHeader(arg_0));
        }
    }

    private static void filterLink(OASFilter filter, Link model) {
        if (model != null && model.getServer() != null) {
            model.setServer(filter.filterServer(model.getServer()));
        }
    }

    private static void filterParameter(OASFilter filter, Parameter model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
            FilterUtil.filter(filter, model.getSchema(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Parameter)model).setSchema(arg_0));
        }
    }

    private static void filterRequestBody(OASFilter filter, RequestBody model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
        }
    }

    private static void filterAPIResponse(OASFilter filter, APIResponse model) {
        if (model != null) {
            FilterUtil.filterContent(filter, model.getContent());
            FilterUtil.filter(filter, model.getHeaders(), FilterUtil::filterHeader, arg_0 -> ((OASFilter)filter).filterHeader(arg_0), arg_0 -> ((APIResponse)model).removeHeader(arg_0));
            FilterUtil.filter(filter, model.getLinks(), FilterUtil::filterLink, arg_0 -> ((OASFilter)filter).filterLink(arg_0), arg_0 -> ((APIResponse)model).removeLink(arg_0));
        }
    }

    private static void filterSchema(OASFilter filter, Schema model) {
        if (model != null) {
            FilterUtil.filter(filter, model.getAdditionalPropertiesSchema(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).setAdditionalPropertiesSchema(arg_0));
            FilterUtil.filter(filter, model.getAllOf(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).removeAllOf(arg_0));
            FilterUtil.filter(filter, model.getAnyOf(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).removeAnyOf(arg_0));
            FilterUtil.filter(filter, model.getOneOf(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).removeOneOf(arg_0));
            FilterUtil.filter(filter, model.getItems(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).setItems(arg_0));
            FilterUtil.filter(filter, model.getNot(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).setNot(arg_0));
            FilterUtil.filter(filter, model.getProperties(), FilterUtil::filterSchema, arg_0 -> ((OASFilter)filter).filterSchema(arg_0), arg_0 -> ((Schema)model).removeProperty(arg_0));
        }
    }
}

