package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ApplyGuard;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link ApplyGuardConfig} config interface, do not modify.
 */
public final class ApplyGuardConfigImpl implements ApplyGuardConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Description for the error message: a fully qualified method name.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final ApplyGuard instance;

    /**
     * Cached value of the {@code ApplyGuard.value} annotation member; {@code null} if not looked up yet.
     */
    private String _value;

    private ApplyGuardConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(ApplyGuard.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.applyGuard;
    }

    public static ApplyGuardConfigImpl create(FaultToleranceMethod method) {
        if (method.applyGuard == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("apply-guard.enabled", "ApplyGuard/enabled", method.method)) {
            return null;
        }
        return new ApplyGuardConfigImpl(method);
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ApplyGuard.class;
    }

    @Override
    public String value() {
        if (_value == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".apply-guard.value";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/ApplyGuard/value";
                _value = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (_value == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.apply-guard.value";
                // <annotation>/<member>
                String oldKey = "ApplyGuard/value";
                _value = config.getOptionalValue(newKey, String.class).or(() -> config.getOptionalValue(oldKey, String.class)).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public void materialize() {
        value();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @ApplyGuard on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @ApplyGuard." + member + " on " + description + ": " + reason);
    }
}
