package io.smallrye.faulttolerance;

import java.util.Locale;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Class;
import java.lang.String;
import jakarta.enterprise.inject.spi.DefinitionException;
import org.jboss.logging.Logger;
import java.util.Arrays;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;


import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
public class CdiLogger_$logger extends DelegatingBasicLogger implements CdiLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = CdiLogger_$logger.class.getName();
    public CdiLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activated(final String version) {
        super.log.logf(FQCN, INFO, null, activated$str(), version);
    }
    protected String activated$str() {
        return "SRFTL00001: MicroProfile: Fault Tolerance activated (SmallRye Fault Tolerance version: %s)";
    }
    protected String multipleCircuitBreakersWithTheSameName$str() {
        return "SRFTL00002: Multiple circuit breakers have the same name '%s': %s";
    }
    @Override
    public final DefinitionException multipleCircuitBreakersWithTheSameName(final String name, final Set<String> useSites) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), multipleCircuitBreakersWithTheSameName$str(), name, useSites));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String backoffAnnotationWithoutRetry$str() {
        return "SRFTL00003: Backoff annotation @%s present on '%s', but @Retry is missing";
    }
    @Override
    public final DefinitionException backoffAnnotationWithoutRetry(final String backoffAnnotation, final MethodDescriptor method) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), backoffAnnotationWithoutRetry$str(), backoffAnnotation, method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final DefinitionException backoffAnnotationWithoutRetry(final String backoffAnnotation, final Class<?> clazz) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), backoffAnnotationWithoutRetry$str(), backoffAnnotation, clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bothBlockingNonBlockingPresent$str() {
        return "SRFTL00004: Both @Blocking and @NonBlocking present on '%s'";
    }
    @Override
    public final DefinitionException bothBlockingNonBlockingPresent(final MethodDescriptor method) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), bothBlockingNonBlockingPresent$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final DefinitionException bothBlockingNonBlockingPresent(final Class<?> clazz) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), bothBlockingNonBlockingPresent$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bothAsyncAndAsyncNonBlockingPresent$str() {
        return "SRFTL00005: Both @Asynchronous and @AsynchronousNonBlocking present on '%s'";
    }
    @Override
    public final DefinitionException bothAsyncAndAsyncNonBlockingPresent(final MethodDescriptor method) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), bothAsyncAndAsyncNonBlockingPresent$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final DefinitionException bothAsyncAndAsyncNonBlockingPresent(final Class<?> clazz) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), bothAsyncAndAsyncNonBlockingPresent$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String retryWhenAnnotationWithoutRetry$str() {
        return "SRFTL00006: @RetryWhen present on '%s', but @Retry is missing";
    }
    @Override
    public final DefinitionException retryWhenAnnotationWithoutRetry(final MethodDescriptor method) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), retryWhenAnnotationWithoutRetry$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final DefinitionException retryWhenAnnotationWithoutRetry(final Class<?> clazz) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), retryWhenAnnotationWithoutRetry$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beforeRetryAnnotationWithoutRetry$str() {
        return "SRFTL00007: @BeforeRetry present on '%s', but @Retry is missing";
    }
    @Override
    public final DefinitionException beforeRetryAnnotationWithoutRetry(final MethodDescriptor method) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), beforeRetryAnnotationWithoutRetry$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final DefinitionException beforeRetryAnnotationWithoutRetry(final Class<?> clazz) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), beforeRetryAnnotationWithoutRetry$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleGuardsWithTheSameIdentifier$str() {
        return "SRFTL00008: Multiple Guard/TypedGuard beans have the same identifier '%s': %s";
    }
    @Override
    public final DefinitionException multipleGuardsWithTheSameIdentifier(final String identifier, final Set<String> beans) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), multipleGuardsWithTheSameIdentifier$str(), identifier, beans));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedGuardDoesNotExist$str() {
        return "SRFTL00009: Guard/TypedGuard with identifier '%s' expected, but does not exist";
    }
    @Override
    public final DefinitionException expectedGuardDoesNotExist(final String identifier) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), expectedGuardDoesNotExist$str(), identifier));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String guardWithIdentifierGlobal$str() {
        return "SRFTL00010: Guard/TypedGuard with identifier 'global' is not allowed: %s";
    }
    @Override
    public final DefinitionException guardWithIdentifierGlobal(final String bean) {
        final DefinitionException result = new DefinitionException(String.format(getLoggingLocale(), guardWithIdentifierGlobal$str(), bean));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
