package io.smallrye.faulttolerance.core.timeout;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.logging.Logger;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;


import static org.jboss.logging.Logger.Level.TRACE;

/**
 * Warning this class consists of generated code.
 */
public class TimeoutLogger_$logger extends DelegatingBasicLogger implements TimeoutLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = TimeoutLogger_$logger.class.getName();
    public TimeoutLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void asyncTimeoutTaskCreated(final Object task) {
        if (super.log.isEnabled(TRACE)) {
            final int taskHashCode;
            if (task == null) taskHashCode = 0; else taskHashCode = System.identityHashCode(task);
            super.log.logf(FQCN, TRACE, null, asyncTimeoutTaskCreated$str(), taskHashCode);
        }
    }
    protected String asyncTimeoutTaskCreated$str() {
        return "AsyncTimeoutTask %s created";
    }
    @Override
    public final void asyncTimeoutTaskCompleting(final Object task, final TimeoutException e) {
        if (super.log.isEnabled(TRACE)) {
            final int taskHashCode;
            if (task == null) taskHashCode = 0; else taskHashCode = System.identityHashCode(task);
            super.log.logf(FQCN, TRACE, null, asyncTimeoutTaskCompleting$str(), taskHashCode, e);
        }
    }
    protected String asyncTimeoutTaskCompleting$str() {
        return "AsyncTimeoutTask %s completing with %s";
    }
    @Override
    public final void asyncTimeoutRethrowing(final Throwable e) {
        super.log.logf(FQCN, TRACE, null, asyncTimeoutRethrowing$str(), e);
    }
    protected String asyncTimeoutRethrowing$str() {
        return "AsyncTimeout rethrowing %s";
    }
}
