package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link RetryConfig} config interface, do not modify.
 */
public final class RetryConfigImpl implements RetryConfig {
    /**
     * Description for the error message: a fully qualified method name or identifier.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>} or {@code <id>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Retry instance;

    /**
     * Cached value of the {@code Retry.maxRetries} annotation member; {@code null} if not looked up yet.
     */
    private Integer _maxRetries;

    /**
     * Cached value of the {@code Retry.delay} annotation member; {@code null} if not looked up yet.
     */
    private Long _delay;

    /**
     * Cached value of the {@code Retry.delayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _delayUnit;

    /**
     * Cached value of the {@code Retry.maxDuration} annotation member; {@code null} if not looked up yet.
     */
    private Long _maxDuration;

    /**
     * Cached value of the {@code Retry.durationUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _durationUnit;

    /**
     * Cached value of the {@code Retry.jitter} annotation member; {@code null} if not looked up yet.
     */
    private Long _jitter;

    /**
     * Cached value of the {@code Retry.jitterDelayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _jitterDelayUnit;

    /**
     * Cached value of the {@code Retry.retryOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _retryOn;

    /**
     * Cached value of the {@code Retry.abortOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _abortOn;

    private RetryConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(Retry.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.retry;
    }

    private RetryConfigImpl(String id, Retry instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static RetryConfigImpl create(FaultToleranceMethod method) {
        if (method.retry == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("retry.enabled", "Retry/enabled", method.method)) {
            return null;
        }
        return new RetryConfigImpl(method);
    }

    public static RetryConfigImpl create(String id, Supplier<Retry> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("retry.enabled", "Retry/enabled", id)) {
            return null;
        }
        return new RetryConfigImpl(id, supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Retry.class;
    }

    @Override
    public int maxRetries() {
        if (_maxRetries == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.max-retries";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Retry/maxRetries";
                _maxRetries = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_maxRetries == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry.max-retries";
                // <annotation>/<member>
                String oldKey = "Retry/maxRetries";
                _maxRetries = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_maxRetries == null) {
                // annotation value
                _maxRetries = instance.maxRetries();
            }
        }
        return _maxRetries;
    }

    @Override
    public long delay() {
        if (_delay == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.delay";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Retry/delay";
                _delay = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_delay == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry.delay";
                // <annotation>/<member>
                String oldKey = "Retry/delay";
                _delay = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_delay == null) {
                // annotation value
                _delay = instance.delay();
            }
        }
        return _delay;
    }

    @Override
    public ChronoUnit delayUnit() {
        if (_delayUnit == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.delay-unit";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Retry/delayUnit";
                _delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_delayUnit == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry.delay-unit";
                // <annotation>/<member>
                String oldKey = "Retry/delayUnit";
                _delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_delayUnit == null) {
                // annotation value
                _delayUnit = instance.delayUnit();
            }
        }
        return _delayUnit;
    }

    @Override
    public long maxDuration() {
        if (_maxDuration == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.max-duration";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Retry/maxDuration";
                _maxDuration = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_maxDuration == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry.max-duration";
                // <annotation>/<member>
                String oldKey = "Retry/maxDuration";
                _maxDuration = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_maxDuration == null) {
                // annotation value
                _maxDuration = instance.maxDuration();
            }
        }
        return _maxDuration;
    }

    @Override
    public ChronoUnit durationUnit() {
        if (_durationUnit == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.max-duration-unit";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Retry/durationUnit";
                _durationUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_durationUnit == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry.max-duration-unit";
                // <annotation>/<member>
                String oldKey = "Retry/durationUnit";
                _durationUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_durationUnit == null) {
                // annotation value
                _durationUnit = instance.durationUnit();
            }
        }
        return _durationUnit;
    }

    @Override
    public long jitter() {
        if (_jitter == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.jitter";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Retry/jitter";
                _jitter = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_jitter == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry.jitter";
                // <annotation>/<member>
                String oldKey = "Retry/jitter";
                _jitter = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_jitter == null) {
                // annotation value
                _jitter = instance.jitter();
            }
        }
        return _jitter;
    }

    @Override
    public ChronoUnit jitterDelayUnit() {
        if (_jitterDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.jitter-unit";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Retry/jitterDelayUnit";
                _jitterDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_jitterDelayUnit == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry.jitter-unit";
                // <annotation>/<member>
                String oldKey = "Retry/jitterDelayUnit";
                _jitterDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_jitterDelayUnit == null) {
                // annotation value
                _jitterDelayUnit = instance.jitterDelayUnit();
            }
        }
        return _jitterDelayUnit;
    }

    @Override
    public Class<? extends Throwable>[] retryOn() {
        if (_retryOn == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.retry-on";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Retry/retryOn";
                _retryOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_retryOn == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry.retry-on";
                // <annotation>/<member>
                String oldKey = "Retry/retryOn";
                _retryOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_retryOn == null) {
                // annotation value
                _retryOn = instance.retryOn();
            }
        }
        return _retryOn;
    }

    @Override
    public Class<? extends Throwable>[] abortOn() {
        if (_abortOn == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry.abort-on";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Retry/abortOn";
                _abortOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_abortOn == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.retry.abort-on";
                // <annotation>/<member>
                String oldKey = "Retry/abortOn";
                _abortOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_abortOn == null) {
                // annotation value
                _abortOn = instance.abortOn();
            }
        }
        return _abortOn;
    }

    @Override
    public void materialize() {
        maxRetries();
        delay();
        delayUnit();
        maxDuration();
        durationUnit();
        jitter();
        jitterDelayUnit();
        retryOn();
        abortOn();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Retry on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Retry." + member + " on " + description + ": " + reason);
    }
}
