package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link ExponentialBackoffConfig} config interface, do not modify.
 */
public final class ExponentialBackoffConfigImpl implements ExponentialBackoffConfig {
    /**
     * Description for the error message: a fully qualified method name or identifier.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>} or {@code <id>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final ExponentialBackoff instance;

    /**
     * Cached value of the {@code ExponentialBackoff.factor} annotation member; {@code null} if not looked up yet.
     */
    private Integer _factor;

    /**
     * Cached value of the {@code ExponentialBackoff.maxDelay} annotation member; {@code null} if not looked up yet.
     */
    private Long _maxDelay;

    /**
     * Cached value of the {@code ExponentialBackoff.maxDelayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _maxDelayUnit;

    private ExponentialBackoffConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(ExponentialBackoff.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.exponentialBackoff;
    }

    private ExponentialBackoffConfigImpl(String id, ExponentialBackoff instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static ExponentialBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.exponentialBackoff == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("exponential-backoff.enabled", "ExponentialBackoff/enabled", method.method)) {
            return null;
        }
        return new ExponentialBackoffConfigImpl(method);
    }

    public static ExponentialBackoffConfigImpl create(String id,
            Supplier<ExponentialBackoff> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("exponential-backoff.enabled", "ExponentialBackoff/enabled", id)) {
            return null;
        }
        return new ExponentialBackoffConfigImpl(id, supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ExponentialBackoff.class;
    }

    @Override
    public int factor() {
        if (_factor == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".exponential-backoff.factor";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/ExponentialBackoff/factor";
                _factor = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_factor == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.exponential-backoff.factor";
                // <annotation>/<member>
                String oldKey = "ExponentialBackoff/factor";
                _factor = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_factor == null) {
                // annotation value
                _factor = instance.factor();
            }
        }
        return _factor;
    }

    @Override
    public long maxDelay() {
        if (_maxDelay == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".exponential-backoff.max-delay";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/ExponentialBackoff/maxDelay";
                _maxDelay = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_maxDelay == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.exponential-backoff.max-delay";
                // <annotation>/<member>
                String oldKey = "ExponentialBackoff/maxDelay";
                _maxDelay = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_maxDelay == null) {
                // annotation value
                _maxDelay = instance.maxDelay();
            }
        }
        return _maxDelay;
    }

    @Override
    public ChronoUnit maxDelayUnit() {
        if (_maxDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".exponential-backoff.max-delay-unit";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/ExponentialBackoff/maxDelayUnit";
                _maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_maxDelayUnit == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.exponential-backoff.max-delay-unit";
                // <annotation>/<member>
                String oldKey = "ExponentialBackoff/maxDelayUnit";
                _maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_maxDelayUnit == null) {
                // annotation value
                _maxDelayUnit = instance.maxDelayUnit();
            }
        }
        return _maxDelayUnit;
    }

    @Override
    public void materialize() {
        factor();
        maxDelay();
        maxDelayUnit();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @ExponentialBackoff on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @ExponentialBackoff." + member + " on " + description + ": " + reason);
    }
}
