package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import java.lang.Class;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link CircuitBreakerConfig} config interface, do not modify.
 */
public final class CircuitBreakerConfigImpl implements CircuitBreakerConfig {
    /**
     * Description for the error message: a fully qualified method name or identifier.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>} or {@code <id>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final CircuitBreaker instance;

    /**
     * Cached value of the {@code CircuitBreaker.failOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _failOn;

    /**
     * Cached value of the {@code CircuitBreaker.skipOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _skipOn;

    /**
     * Cached value of the {@code CircuitBreaker.delay} annotation member; {@code null} if not looked up yet.
     */
    private Long _delay;

    /**
     * Cached value of the {@code CircuitBreaker.delayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _delayUnit;

    /**
     * Cached value of the {@code CircuitBreaker.requestVolumeThreshold} annotation member; {@code null} if not looked up yet.
     */
    private Integer _requestVolumeThreshold;

    /**
     * Cached value of the {@code CircuitBreaker.failureRatio} annotation member; {@code null} if not looked up yet.
     */
    private Double _failureRatio;

    /**
     * Cached value of the {@code CircuitBreaker.successThreshold} annotation member; {@code null} if not looked up yet.
     */
    private Integer _successThreshold;

    private CircuitBreakerConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(CircuitBreaker.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.circuitBreaker;
    }

    private CircuitBreakerConfigImpl(String id, CircuitBreaker instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static CircuitBreakerConfigImpl create(FaultToleranceMethod method) {
        if (method.circuitBreaker == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("circuit-breaker.enabled", "CircuitBreaker/enabled", method.method)) {
            return null;
        }
        return new CircuitBreakerConfigImpl(method);
    }

    public static CircuitBreakerConfigImpl create(String id, Supplier<CircuitBreaker> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("circuit-breaker.enabled", "CircuitBreaker/enabled", id)) {
            return null;
        }
        return new CircuitBreakerConfigImpl(id, supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CircuitBreaker.class;
    }

    @Override
    public Class<? extends Throwable>[] failOn() {
        if (_failOn == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.fail-on";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/CircuitBreaker/failOn";
                _failOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_failOn == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.circuit-breaker.fail-on";
                // <annotation>/<member>
                String oldKey = "CircuitBreaker/failOn";
                _failOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_failOn == null) {
                // annotation value
                _failOn = instance.failOn();
            }
        }
        return _failOn;
    }

    @Override
    public Class<? extends Throwable>[] skipOn() {
        if (_skipOn == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.skip-on";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/CircuitBreaker/skipOn";
                _skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_skipOn == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.circuit-breaker.skip-on";
                // <annotation>/<member>
                String oldKey = "CircuitBreaker/skipOn";
                _skipOn = config.getOptionalValue(newKey, Class[].class).or(() -> config.getOptionalValue(oldKey, Class[].class)).orElse(null);
            }
            if (_skipOn == null) {
                // annotation value
                _skipOn = instance.skipOn();
            }
        }
        return _skipOn;
    }

    @Override
    public long delay() {
        if (_delay == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.delay";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/CircuitBreaker/delay";
                _delay = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_delay == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.circuit-breaker.delay";
                // <annotation>/<member>
                String oldKey = "CircuitBreaker/delay";
                _delay = config.getOptionalValue(newKey, long.class).or(() -> config.getOptionalValue(oldKey, long.class)).orElse(null);
            }
            if (_delay == null) {
                // annotation value
                _delay = instance.delay();
            }
        }
        return _delay;
    }

    @Override
    public ChronoUnit delayUnit() {
        if (_delayUnit == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.delay-unit";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/CircuitBreaker/delayUnit";
                _delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_delayUnit == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.circuit-breaker.delay-unit";
                // <annotation>/<member>
                String oldKey = "CircuitBreaker/delayUnit";
                _delayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (_delayUnit == null) {
                // annotation value
                _delayUnit = instance.delayUnit();
            }
        }
        return _delayUnit;
    }

    @Override
    public int requestVolumeThreshold() {
        if (_requestVolumeThreshold == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.request-volume-threshold";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/CircuitBreaker/requestVolumeThreshold";
                _requestVolumeThreshold = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_requestVolumeThreshold == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.circuit-breaker.request-volume-threshold";
                // <annotation>/<member>
                String oldKey = "CircuitBreaker/requestVolumeThreshold";
                _requestVolumeThreshold = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_requestVolumeThreshold == null) {
                // annotation value
                _requestVolumeThreshold = instance.requestVolumeThreshold();
            }
        }
        return _requestVolumeThreshold;
    }

    @Override
    public double failureRatio() {
        if (_failureRatio == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.failure-ratio";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/CircuitBreaker/failureRatio";
                _failureRatio = config.getOptionalValue(newKey, double.class).or(() -> config.getOptionalValue(oldKey, double.class)).orElse(null);
            }
            if (_failureRatio == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.circuit-breaker.failure-ratio";
                // <annotation>/<member>
                String oldKey = "CircuitBreaker/failureRatio";
                _failureRatio = config.getOptionalValue(newKey, double.class).or(() -> config.getOptionalValue(oldKey, double.class)).orElse(null);
            }
            if (_failureRatio == null) {
                // annotation value
                _failureRatio = instance.failureRatio();
            }
        }
        return _failureRatio;
    }

    @Override
    public int successThreshold() {
        if (_successThreshold == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".circuit-breaker.success-threshold";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/CircuitBreaker/successThreshold";
                _successThreshold = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_successThreshold == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.circuit-breaker.success-threshold";
                // <annotation>/<member>
                String oldKey = "CircuitBreaker/successThreshold";
                _successThreshold = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_successThreshold == null) {
                // annotation value
                _successThreshold = instance.successThreshold();
            }
        }
        return _successThreshold;
    }

    @Override
    public void materialize() {
        failOn();
        skipOn();
        delay();
        delayUnit();
        requestVolumeThreshold();
        failureRatio();
        successThreshold();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @CircuitBreaker on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @CircuitBreaker." + member + " on " + description + ": " + reason);
    }
}
