package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link BulkheadConfig} config interface, do not modify.
 */
public final class BulkheadConfigImpl implements BulkheadConfig {
    /**
     * Description for the error message: a fully qualified method name or identifier.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>} or {@code <id>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Bulkhead instance;

    /**
     * Cached value of the {@code Bulkhead.value} annotation member; {@code null} if not looked up yet.
     */
    private Integer _value;

    /**
     * Cached value of the {@code Bulkhead.waitingTaskQueue} annotation member; {@code null} if not looked up yet.
     */
    private Integer _waitingTaskQueue;

    private BulkheadConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(Bulkhead.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.bulkhead;
    }

    private BulkheadConfigImpl(String id, Bulkhead instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static BulkheadConfigImpl create(FaultToleranceMethod method) {
        if (method.bulkhead == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("bulkhead.enabled", "Bulkhead/enabled", method.method)) {
            return null;
        }
        return new BulkheadConfigImpl(method);
    }

    public static BulkheadConfigImpl create(String id, Supplier<Bulkhead> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("bulkhead.enabled", "Bulkhead/enabled", id)) {
            return null;
        }
        return new BulkheadConfigImpl(id, supplier.get());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Bulkhead.class;
    }

    @Override
    public int value() {
        if (_value == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".bulkhead.value";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Bulkhead/value";
                _value = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_value == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.bulkhead.value";
                // <annotation>/<member>
                String oldKey = "Bulkhead/value";
                _value = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_value == null) {
                // annotation value
                _value = instance.value();
            }
        }
        return _value;
    }

    @Override
    public int waitingTaskQueue() {
        if (_waitingTaskQueue == null) {
            Config config = ConfigProvider.getConfig();
             {
                // smallrye.faulttolerance."<configKey>".<annotation>.<member>
                String newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".bulkhead.waiting-task-queue";
                // <configKey>/<annotation>/<member>
                String oldKey = this.configKey + "/Bulkhead/waitingTaskQueue";
                _waitingTaskQueue = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_waitingTaskQueue == null) {
                // smallrye.faulttolerance.global.<annotation>.<member>
                String newKey = "smallrye.faulttolerance.global.bulkhead.waiting-task-queue";
                // <annotation>/<member>
                String oldKey = "Bulkhead/waitingTaskQueue";
                _waitingTaskQueue = config.getOptionalValue(newKey, int.class).or(() -> config.getOptionalValue(oldKey, int.class)).orElse(null);
            }
            if (_waitingTaskQueue == null) {
                // annotation value
                _waitingTaskQueue = instance.waitingTaskQueue();
            }
        }
        return _waitingTaskQueue;
    }

    @Override
    public void materialize() {
        value();
        waitingTaskQueue();
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Bulkhead on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Bulkhead." + member + " on " + description + ": " + reason);
    }
}
