package io.vertx.mutiny.ext.auth.mongo;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import io.vertx.ext.auth.mongo.MongoAuthorizationOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Utility to create users/roles/permissions. This is a helper class and not intended to be a full user
 * management utility. While the standard authentication and authorization interfaces will require usually
 * read only access to the database, in order to use this API a full read/write access must be granted.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.MongoUserUtil original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.mongo.MongoUserUtil.class)
public class MongoUserUtil {

  public static final io.smallrye.mutiny.vertx.TypeArg<MongoUserUtil> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MongoUserUtil((io.vertx.ext.auth.mongo.MongoUserUtil) obj),
    MongoUserUtil::getDelegate
  );

  private final io.vertx.ext.auth.mongo.MongoUserUtil delegate;
  
  public MongoUserUtil(io.vertx.ext.auth.mongo.MongoUserUtil delegate) {
    this.delegate = delegate;
  }

  public MongoUserUtil(Object delegate) {
    this.delegate = (io.vertx.ext.auth.mongo.MongoUserUtil)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MongoUserUtil() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.mongo.MongoUserUtil getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoUserUtil that = (MongoUserUtil) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param client the client with write rights to the database.
   * @return the instance
   */
  public static io.vertx.mutiny.ext.auth.mongo.MongoUserUtil create(io.vertx.mutiny.ext.mongo.MongoClient client) { 
    io.vertx.mutiny.ext.auth.mongo.MongoUserUtil ret = io.vertx.mutiny.ext.auth.mongo.MongoUserUtil.newInstance((io.vertx.ext.auth.mongo.MongoUserUtil)io.vertx.ext.auth.mongo.MongoUserUtil.create(client.getDelegate()));
    return ret;
  }

  /**
   * @param client the client with write rights to the database.
   * @param authenticationOptions 
   * @param authorizationOptions 
   * @return the instance
   */
  public static io.vertx.mutiny.ext.auth.mongo.MongoUserUtil create(io.vertx.mutiny.ext.mongo.MongoClient client, io.vertx.ext.auth.mongo.MongoAuthenticationOptions authenticationOptions, io.vertx.ext.auth.mongo.MongoAuthorizationOptions authorizationOptions) { 
    io.vertx.mutiny.ext.auth.mongo.MongoUserUtil ret = io.vertx.mutiny.ext.auth.mongo.MongoUserUtil.newInstance((io.vertx.ext.auth.mongo.MongoUserUtil)io.vertx.ext.auth.mongo.MongoUserUtil.create(client.getDelegate(), authenticationOptions, authorizationOptions));
    return ret;
  }

  /**
   * Insert a user into a database.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param username the username to be set
   * @param password the password in clear text, will be adapted following the definitions of the defined strategy
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> createUser(String username, String password) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createUser(username, password, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createUser(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param username the username to be set
   * @param password the password in clear text, will be adapted following the definitions of the defined strategy
   * @return the String instance produced by the operation.
   */
  public String createUserAndAwait(String username, String password) { 
    return (String) createUser(username, password).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createUser(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createUser(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createUser(String,String)} but you don't need to compose it with other operations.
   * @param username the username to be set
   * @param password the password in clear text, will be adapted following the definitions of the defined strategy
   * @return the instance of MongoUserUtil to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoUserUtil createUserAndForget(String username, String password) { 
    createUser(username, password).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Insert a user into a database.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.mutiny.ext.auth.HashingStrategy#hash}
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> createHashedUser(String username, String hash) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createHashedUser(username, hash, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createHashedUser(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.mutiny.ext.auth.HashingStrategy#hash}
   * @return the String instance produced by the operation.
   */
  public String createHashedUserAndAwait(String username, String hash) { 
    return (String) createHashedUser(username, hash).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createHashedUser(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createHashedUser(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createHashedUser(String,String)} but you don't need to compose it with other operations.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.mutiny.ext.auth.HashingStrategy#hash}
   * @return the instance of MongoUserUtil to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoUserUtil createHashedUserAndForget(String username, String hash) { 
    createHashedUser(username, hash).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Insert a user role into a database.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param username the username to be set
   * @param roles a to be set
   * @param permissions a to be set
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> createUserRolesAndPermissions(String username, List<String> roles, List<String> permissions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createUserRolesAndPermissions(username, roles, permissions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createUserRolesAndPermissions(String,List,List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param username the username to be set
   * @param roles a to be set
   * @param permissions a to be set
   * @return the String instance produced by the operation.
   */
  public String createUserRolesAndPermissionsAndAwait(String username, List<String> roles, List<String> permissions) { 
    return (String) createUserRolesAndPermissions(username, roles, permissions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createUserRolesAndPermissions(String,List,List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createUserRolesAndPermissions(String,List,List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.mongo.MongoUserUtil#createUserRolesAndPermissions(String,List,List)} but you don't need to compose it with other operations.
   * @param username the username to be set
   * @param roles a to be set
   * @param permissions a to be set
   * @return the instance of MongoUserUtil to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoUserUtil createUserRolesAndPermissionsAndForget(String username, List<String> roles, List<String> permissions) { 
    createUserRolesAndPermissions(username, roles, permissions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  public static  MongoUserUtil newInstance(io.vertx.ext.auth.mongo.MongoUserUtil arg) {
    return arg != null ? new MongoUserUtil(arg) : null;
  }

}
