package io.vertx.mutiny.ext.auth.mongo;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.auth.mongo.MongoAuthenticationOptions;
import java.util.Map;

/**
 * An extension of AuthProvider which is using  as store
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.MongoAuthentication original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.mongo.MongoAuthentication.class)
public class MongoAuthentication extends io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<MongoAuthentication> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MongoAuthentication((io.vertx.ext.auth.mongo.MongoAuthentication) obj),
    MongoAuthentication::getDelegate
  );

  private final io.vertx.ext.auth.mongo.MongoAuthentication delegate;
  
  public MongoAuthentication(io.vertx.ext.auth.mongo.MongoAuthentication delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MongoAuthentication(Object delegate) {
    super((io.vertx.ext.auth.mongo.MongoAuthentication)delegate);
    this.delegate = (io.vertx.ext.auth.mongo.MongoAuthentication)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MongoAuthentication() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.mongo.MongoAuthentication getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoAuthentication that = (MongoAuthentication) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param mongoClient an instance of  to be used for data storage and retrival
   * @param options the configuration object for the current instance.
   * @return the created instance of {@link io.vertx.mutiny.ext.auth.mongo.MongoAuthentication}
   */
  public static io.vertx.mutiny.ext.auth.mongo.MongoAuthentication create(io.vertx.mutiny.ext.mongo.MongoClient mongoClient, io.vertx.ext.auth.mongo.MongoAuthenticationOptions options) { 
    io.vertx.mutiny.ext.auth.mongo.MongoAuthentication ret = io.vertx.mutiny.ext.auth.mongo.MongoAuthentication.newInstance((io.vertx.ext.auth.mongo.MongoAuthentication)io.vertx.ext.auth.mongo.MongoAuthentication.create(mongoClient.getDelegate(), options));
    return ret;
  }

  public static io.vertx.mutiny.ext.auth.mongo.MongoAuthentication create(io.vertx.mutiny.ext.mongo.MongoClient mongoClient, io.vertx.mutiny.ext.auth.mongo.HashStrategy hashStrategy, io.vertx.ext.auth.mongo.MongoAuthenticationOptions options) { 
    io.vertx.mutiny.ext.auth.mongo.MongoAuthentication ret = io.vertx.mutiny.ext.auth.mongo.MongoAuthentication.newInstance((io.vertx.ext.auth.mongo.MongoAuthentication)io.vertx.ext.auth.mongo.MongoAuthentication.create(mongoClient.getDelegate(), hashStrategy.getDelegate(), options));
    return ret;
  }

  /**
   * @param id 
   * @param params 
   * @param salt 
   * @param password 
   * @return 
   */
  public String hash(String id, java.util.Map<String, String> params, String salt, String password) { 
    String ret = delegate.hash(id, params, salt, password);
    return ret;
  }

  /**
   * @param id 
   * @param salt 
   * @param password 
   * @return 
   */
  public String hash(String id, String salt, String password) { 
    String ret = delegate.hash(id, salt, password);
    return ret;
  }

  /**
   * The default name of the collection to be used
   */
  public static final String DEFAULT_COLLECTION_NAME = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_COLLECTION_NAME;
  /**
   * The default name of the property for the username, like it is stored in mongodb
   */
  public static final String DEFAULT_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_USERNAME_FIELD;
  /**
   * The default name of the property for the password, like it is stored in mongodb
   */
  public static final String DEFAULT_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_PASSWORD_FIELD;
  /**
   * The default name of the property for the username, like it is transported in credentials by method
   * {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate}
   */
  public static final String DEFAULT_CREDENTIAL_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_CREDENTIAL_USERNAME_FIELD;
  /**
   * The default name of the property for the password, like it is transported in credentials by method
   * {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate}
   */
  public static final String DEFAULT_CREDENTIAL_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_CREDENTIAL_PASSWORD_FIELD;
  /**
   * The default name of the property for the salt field
   */
  public static final String DEFAULT_SALT_FIELD = io.vertx.ext.auth.mongo.MongoAuthentication.DEFAULT_SALT_FIELD;
  public static  MongoAuthentication newInstance(io.vertx.ext.auth.mongo.MongoAuthentication arg) {
    return arg != null ? new MongoAuthentication(arg) : null;
  }

}
