package io.vertx.mutiny.ext.auth.mongo;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.ext.auth.mongo.HashAlgorithm;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * An extension of AuthProvider which is using  as store
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.MongoAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.mongo.MongoAuth.class)
public class MongoAuth extends io.vertx.mutiny.ext.auth.AuthProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<MongoAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MongoAuth((io.vertx.ext.auth.mongo.MongoAuth) obj),
    MongoAuth::getDelegate
  );

  private final io.vertx.ext.auth.mongo.MongoAuth delegate;
  
  public MongoAuth(io.vertx.ext.auth.mongo.MongoAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MongoAuth(Object delegate) {
    super((io.vertx.ext.auth.mongo.MongoAuth)delegate);
    this.delegate = (io.vertx.ext.auth.mongo.MongoAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MongoAuth() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.mongo.MongoAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoAuth that = (MongoAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param mongoClient an instance of  to be used for data storage and retrival
   * @param config the configuration object for the current instance. By this
   * @return the created instance of {@link io.vertx.mutiny.ext.auth.mongo.MongoAuth}s
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.mongo.MongoAuth create(io.vertx.mutiny.ext.mongo.MongoClient mongoClient, JsonObject config) { 
    io.vertx.mutiny.ext.auth.mongo.MongoAuth ret = io.vertx.mutiny.ext.auth.mongo.MongoAuth.newInstance((io.vertx.ext.auth.mongo.MongoAuth)io.vertx.ext.auth.mongo.MongoAuth.create(mongoClient.getDelegate(), config));
    return ret;
  }

  /**
   * @param collectionName the name of the collection to be used for storing and reading user data
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setCollectionName(String collectionName) { 
    delegate.setCollectionName(collectionName);
    return this;
  }

  /**
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setUsernameField(String fieldName) { 
    delegate.setUsernameField(fieldName);
    return this;
  }

  /**
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setPasswordField(String fieldName) { 
    delegate.setPasswordField(fieldName);
    return this;
  }

  /**
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setRoleField(String fieldName) { 
    delegate.setRoleField(fieldName);
    return this;
  }

  /**
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setPermissionField(String fieldName) { 
    delegate.setPermissionField(fieldName);
    return this;
  }

  /**
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setUsernameCredentialField(String fieldName) { 
    delegate.setUsernameCredentialField(fieldName);
    return this;
  }

  /**
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setPasswordCredentialField(String fieldName) { 
    delegate.setPasswordCredentialField(fieldName);
    return this;
  }

  /**
   * @param fieldName the name of the field to be used
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setSaltField(String fieldName) { 
    delegate.setSaltField(fieldName);
    return this;
  }

  /**
   * @return the collectionName
   * @deprecated   */
  @Deprecated
  public String getCollectionName() { 
    String ret = delegate.getCollectionName();
    return ret;
  }

  /**
   * @return the usernameField
   * @deprecated   */
  @Deprecated
  public String getUsernameField() { 
    String ret = delegate.getUsernameField();
    return ret;
  }

  /**
   * @return the passwordField
   * @deprecated   */
  @Deprecated
  public String getPasswordField() { 
    String ret = delegate.getPasswordField();
    return ret;
  }

  /**
   * @return the roleField
   * @deprecated   */
  @Deprecated
  public String getRoleField() { 
    String ret = delegate.getRoleField();
    return ret;
  }

  /**
   * @return the permissionField
   * @deprecated   */
  @Deprecated
  public String getPermissionField() { 
    String ret = delegate.getPermissionField();
    return ret;
  }

  /**
   * @return the usernameCredentialField
   * @deprecated   */
  @Deprecated
  public String getUsernameCredentialField() { 
    String ret = delegate.getUsernameCredentialField();
    return ret;
  }

  /**
   * @return the passwordCredentialField
   * @deprecated   */
  @Deprecated
  public String getPasswordCredentialField() { 
    String ret = delegate.getPasswordCredentialField();
    return ret;
  }

  /**
   * @return the saltField
   * @deprecated   */
  @Deprecated
  public String getSaltField() { 
    String ret = delegate.getSaltField();
    return ret;
  }

  /**
   * @param hashStrategy the {@link io.vertx.mutiny.ext.auth.mongo.HashStrategy} to be set
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setHashStrategy(io.vertx.mutiny.ext.auth.mongo.HashStrategy hashStrategy) { 
    delegate.setHashStrategy(hashStrategy.getDelegate());
    return this;
  }

  /**
   * @return the defined instance of {@link io.vertx.mutiny.ext.auth.mongo.HashStrategy}
   * @deprecated   */
  @Deprecated
  public io.vertx.mutiny.ext.auth.mongo.HashStrategy getHashStrategy() { 
    io.vertx.mutiny.ext.auth.mongo.HashStrategy ret = io.vertx.mutiny.ext.auth.mongo.HashStrategy.newInstance((io.vertx.ext.auth.mongo.HashStrategy)delegate.getHashStrategy());
    return ret;
  }

  /**
   * @param hashAlgorithm the {@link io.vertx.ext.auth.mongo.HashAlgorithm} to be set
   * @return the current instance itself for fluent calls
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.mongo.MongoAuth setHashAlgorithm(io.vertx.ext.auth.mongo.HashAlgorithm hashAlgorithm) { 
    delegate.setHashAlgorithm(hashAlgorithm);
    return this;
  }

  /**
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined {@link io.vertx.mutiny.ext.auth.mongo.HashStrategy}
   * @param roles a list of roles to be set
   * @param permissions a list of permissions to be set
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated Please use {@link MongoUserUtil} instead. Insert a new user into mongo in the convenient way   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<String> insertUser(String username, String password, List<String> roles, List<String> permissions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.insertUser(username, password, roles, permissions, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.mongo.MongoAuth#insertUser(String,String,List,List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined {@link io.vertx.mutiny.ext.auth.mongo.HashStrategy}
   * @param roles a list of roles to be set
   * @param permissions a list of permissions to be set
   * @return the String instance produced by the operation.
   * @deprecated Please use {@link MongoUserUtil} instead. Insert a new user into mongo in the convenient way   */
  @Deprecated
  public String insertUserAndAwait(String username, String password, List<String> roles, List<String> permissions) { 
    return (String) insertUser(username, password, roles, permissions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.mongo.MongoAuth#insertUser(String,String,List,List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.mongo.MongoAuth#insertUser(String,String,List,List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.mongo.MongoAuth#insertUser(String,String,List,List)} but you don't need to compose it with other operations.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined {@link io.vertx.mutiny.ext.auth.mongo.HashStrategy}
   * @param roles a list of roles to be set
   * @param permissions a list of permissions to be set
   * @deprecated Please use {@link MongoUserUtil} instead. Insert a new user into mongo in the convenient way   */
  @Deprecated
  public void insertUserAndForget(String username, String password, List<String> roles, List<String> permissions) { 
    insertUser(username, password, roles, permissions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * The property name to be used to set the name of the collection inside the config
   */
  public static final String PROPERTY_COLLECTION_NAME = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_COLLECTION_NAME;
  /**
   * The property name to be used to set the name of the field, where the username is stored inside
   */
  public static final String PROPERTY_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_USERNAME_FIELD;
  /**
   * The property name to be used to set the name of the field, where the roles are stored inside
   */
  public static final String PROPERTY_ROLE_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_ROLE_FIELD;
  /**
   * The property name to be used to set the name of the field, where the permissions are stored inside
   */
  public static final String PROPERTY_PERMISSION_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_PERMISSION_FIELD;
  /**
   * The property name to be used to set the name of the field, where the password is stored inside
   */
  public static final String PROPERTY_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_PASSWORD_FIELD;
  /**
   * The property name to be used to set the name of the field, where the username for the credentials is stored inside
   */
  public static final String PROPERTY_CREDENTIAL_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_CREDENTIAL_USERNAME_FIELD;
  /**
   * The property name to be used to set the name of the field, where the password for the credentials is stored inside
   */
  public static final String PROPERTY_CREDENTIAL_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_CREDENTIAL_PASSWORD_FIELD;
  /**
   * The property name to be used to set the name of the field, where the SALT is stored inside
   */
  public static final String PROPERTY_SALT_FIELD = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_SALT_FIELD;
  /**
   * The property name to be used to set the name of the field, where the salt style is stored inside
   */
  public static final String PROPERTY_SALT_STYLE = io.vertx.ext.auth.mongo.MongoAuth.PROPERTY_SALT_STYLE;
  /**
   * The default name of the collection to be used
   */
  public static final String DEFAULT_COLLECTION_NAME = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_COLLECTION_NAME;
  /**
   * The default name of the property for the username, like it is stored in mongodb
   */
  public static final String DEFAULT_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_USERNAME_FIELD;
  /**
   * The default name of the property for the password, like it is stored in mongodb
   */
  public static final String DEFAULT_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_PASSWORD_FIELD;
  /**
   * The default name of the property for the roles, like it is stored in mongodb. Roles are expected to be saved as
   * JsonArray
   */
  public static final String DEFAULT_ROLE_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_ROLE_FIELD;
  /**
   * The default name of the property for the permissions, like it is stored in mongodb. Permissions are expected to be
   * saved as JsonArray
   */
  public static final String DEFAULT_PERMISSION_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_PERMISSION_FIELD;
  /**
   * The default name of the property for the username, like it is transported in credentials by method
   * {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate}
   */
  public static final String DEFAULT_CREDENTIAL_USERNAME_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_CREDENTIAL_USERNAME_FIELD;
  /**
   * The default name of the property for the password, like it is transported in credentials by method
   * {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider#authenticate}
   */
  public static final String DEFAULT_CREDENTIAL_PASSWORD_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_CREDENTIAL_PASSWORD_FIELD;
  /**
   * The default name of the property for the salt field
   */
  public static final String DEFAULT_SALT_FIELD = io.vertx.ext.auth.mongo.MongoAuth.DEFAULT_SALT_FIELD;
  /**
   * The prefix which is used by the method  when checking for role access
   */
  public static final String ROLE_PREFIX = io.vertx.ext.auth.mongo.MongoAuth.ROLE_PREFIX;
  public static  MongoAuth newInstance(io.vertx.ext.auth.mongo.MongoAuth arg) {
    return arg != null ? new MongoAuth(arg) : null;
  }

}
