package io.vertx.mutiny.ext.auth.mongo;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.auth.mongo.HashSaltStyle;
import io.vertx.ext.auth.mongo.HashAlgorithm;

/**
 * Determines how the hashing is computed in the implementation You can implement this to provide a different hashing
 * strategy to the default.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.mongo.HashStrategy original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.mongo.HashStrategy.class)
public class HashStrategy {

  public static final io.smallrye.mutiny.vertx.TypeArg<HashStrategy> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HashStrategy((io.vertx.ext.auth.mongo.HashStrategy) obj),
    HashStrategy::getDelegate
  );

  private final io.vertx.ext.auth.mongo.HashStrategy delegate;
  
  public HashStrategy(io.vertx.ext.auth.mongo.HashStrategy delegate) {
    this.delegate = delegate;
  }

  public HashStrategy(Object delegate) {
    this.delegate = (io.vertx.ext.auth.mongo.HashStrategy)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HashStrategy() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.mongo.HashStrategy getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HashStrategy that = (HashStrategy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param password the unhashed password
   * @param user the user to get the salt for. This paramter is needed, if the  is declared to be used
   * @return the hashed password
   * @deprecated   */
  @Deprecated
  public String computeHash(String password, io.vertx.mutiny.ext.auth.User user) { 
    String ret = delegate.computeHash(password, user.getDelegate());
    return ret;
  }

  /**
   * @param user the user to get the stored password for
   * @return the password, either as hashed version or as cleartext, depending on the preferences
   * @deprecated   */
  @Deprecated
  public String getStoredPwd(io.vertx.mutiny.ext.auth.User user) { 
    String ret = delegate.getStoredPwd(user.getDelegate());
    return ret;
  }

  /**
   * @param user the user to get the salt for. This paramter is needed, if the  is declared to be used
   * @return null in case of  the salt of the user or a defined external salt
   * @deprecated   */
  @Deprecated
  public String getSalt(io.vertx.mutiny.ext.auth.User user) { 
    String ret = delegate.getSalt(user.getDelegate());
    return ret;
  }

  /**
   * @param salt the salt, which shall be used
   * @deprecated   */
  @Deprecated
  public void setExternalSalt(String salt) { 
    delegate.setExternalSalt(salt);
  }

  /**
   * @param saltStyle the {@link io.vertx.ext.auth.mongo.HashSaltStyle} to be used
   * @deprecated   */
  @Deprecated
  public void setSaltStyle(io.vertx.ext.auth.mongo.HashSaltStyle saltStyle) { 
    delegate.setSaltStyle(saltStyle);
  }

  /**
   * @return the saltStyle
   * @deprecated   */
  @Deprecated
  public io.vertx.ext.auth.mongo.HashSaltStyle getSaltStyle() { 
    io.vertx.ext.auth.mongo.HashSaltStyle ret = delegate.getSaltStyle();
    return ret;
  }

  /**
   * @param algorithm the choosen algorithm
   * @deprecated   */
  @Deprecated
  public void setAlgorithm(io.vertx.ext.auth.mongo.HashAlgorithm algorithm) { 
    delegate.setAlgorithm(algorithm);
  }

  public static  HashStrategy newInstance(io.vertx.ext.auth.mongo.HashStrategy arg) {
    return arg != null ? new HashStrategy(arg) : null;
  }

}
