package io.vertx.mutiny.ext.auth.htdigest;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * An extension of AuthProvider which is using .htdigest file as store
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.htdigest.HtdigestAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.htdigest.HtdigestAuth.class)
public class HtdigestAuth extends io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<HtdigestAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HtdigestAuth((io.vertx.ext.auth.htdigest.HtdigestAuth) obj),
    HtdigestAuth::getDelegate
  );

  private final io.vertx.ext.auth.htdigest.HtdigestAuth delegate;
  
  public HtdigestAuth(io.vertx.ext.auth.htdigest.HtdigestAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public HtdigestAuth(Object delegate) {
    super((io.vertx.ext.auth.htdigest.HtdigestAuth)delegate);
    this.delegate = (io.vertx.ext.auth.htdigest.HtdigestAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HtdigestAuth() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.htdigest.HtdigestAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HtdigestAuth that = (HtdigestAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @return the created instance of {@link io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth}s
   */
  public static io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth ret = io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth.newInstance((io.vertx.ext.auth.htdigest.HtdigestAuth)io.vertx.ext.auth.htdigest.HtdigestAuth.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx 
   * @param htfile the existing htfile.
   * @return the created instance of {@link io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth}s
   */
  public static io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth create(io.vertx.mutiny.core.Vertx vertx, String htfile) { 
    io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth ret = io.vertx.mutiny.ext.auth.htdigest.HtdigestAuth.newInstance((io.vertx.ext.auth.htdigest.HtdigestAuth)io.vertx.ext.auth.htdigest.HtdigestAuth.create(vertx.getDelegate(), htfile));
    return ret;
  }

  /**
   * @return the realm
   */
  public String realm() { 
    String ret = delegate.realm();
    return ret;
  }

  /**
   * The property name to be used to set the name of the collection inside the config
   */
  public static final String HTDIGEST_FILE = io.vertx.ext.auth.htdigest.HtdigestAuth.HTDIGEST_FILE;
  public static  HtdigestAuth newInstance(io.vertx.ext.auth.htdigest.HtdigestAuth arg) {
    return arg != null ? new HtdigestAuth(arg) : null;
  }

}
