/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Function;
import java.util.function.Predicate;

public class UniOnFailureTransform<I, O, E extends Throwable>
extends UniOperator<I, O> {
    private final Function<E, ? extends Throwable> mapper;
    private final Predicate<? super Throwable> predicate;
    private final Class<E> typeOfFailure;

    public UniOnFailureTransform(Uni<I> upstream, Predicate<? super Throwable> predicate, Function<E, ? extends Throwable> mapper, Class<E> typeOfFailure) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
        this.typeOfFailure = ParameterValidation.nonNull(typeOfFailure, "typeOfFailure");
    }

    @Override
    public void subscribe(UniSubscriber<? super O> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnFailureTransformProcessor(subscriber));
    }

    private class UniOnFailureTransformProcessor
    extends UniOperatorProcessor<I, O> {
        public UniOnFailureTransformProcessor(UniSubscriber<? super O> downstream) {
            super(downstream);
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.isCancelled()) {
                boolean test;
                try {
                    test = UniOnFailureTransform.this.predicate.test(failure);
                }
                catch (Throwable err) {
                    this.downstream.onFailure(new CompositeException(failure, err));
                    return;
                }
                if (test) {
                    Throwable outcome;
                    try {
                        outcome = UniOnFailureTransform.this.mapper.apply((Throwable)UniOnFailureTransform.this.typeOfFailure.cast(failure));
                    }
                    catch (Throwable e) {
                        this.downstream.onFailure(e);
                        return;
                    }
                    if (outcome == null) {
                        this.downstream.onFailure(new NullPointerException("The supplier returned `null`"));
                    } else {
                        this.downstream.onFailure(outcome);
                    }
                } else {
                    this.downstream.onFailure(failure);
                }
            } else {
                Infrastructure.handleDroppedException(failure);
            }
        }
    }
}

