/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.version;

import io.servicecomb.serviceregistry.version.VersionRule;
import io.servicecomb.serviceregistry.version.VersionRuleFixedParser;
import io.servicecomb.serviceregistry.version.VersionRuleLatestParser;
import io.servicecomb.serviceregistry.version.VersionRuleParser;
import io.servicecomb.serviceregistry.version.VersionRuleRangeParser;
import io.servicecomb.serviceregistry.version.VersionRuleStartFromParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class VersionRuleUtils {
    private static List<VersionRuleParser> parses = new ArrayList<VersionRuleParser>();
    private static Map<String, VersionRule> versionRuleCache = new ConcurrentHashMap<String, VersionRule>();

    public static VersionRule getOrCreate(String strVersionRule) {
        Objects.requireNonNull(strVersionRule);
        return versionRuleCache.computeIfAbsent(strVersionRule, VersionRuleUtils::create);
    }

    public static VersionRule create(String strVersionRule) {
        strVersionRule = strVersionRule.trim();
        for (VersionRuleParser parser : parses) {
            VersionRule versionRule = parser.parse(strVersionRule);
            if (versionRule == null) continue;
            return versionRule;
        }
        throw new IllegalStateException("never run to here");
    }

    static {
        parses.add(new VersionRuleLatestParser());
        parses.add(new VersionRuleStartFromParser());
        parses.add(new VersionRuleRangeParser());
        parses.add(new VersionRuleFixedParser());
    }
}

