/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.client.http;

import io.servicecomb.foundation.common.net.IpPort;
import io.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import io.servicecomb.serviceregistry.client.http.RequestParam;
import io.servicecomb.serviceregistry.client.http.RestUtils;
import io.servicecomb.serviceregistry.client.http.WebsocketClientPool;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebsocketUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketUtils.class);

    private WebsocketUtils() {
    }

    public static void open(IpPort ipPort, String url, Handler<Void> onOpen, Handler<Void> onClose, Handler<Buffer> onMessage, Handler<Throwable> onException, Handler<Throwable> onConnectFailed) {
        HttpClientWithContext vertxHttpClient = WebsocketClientPool.INSTANCE.getClient();
        vertxHttpClient.runOnContext(client -> client.websocket(ipPort.getPort(), ipPort.getHostOrIp(), url, RestUtils.getDefaultHeaders().addAll(RestUtils.getSignAuthHeaders(RestUtils.createSignRequest(null, ipPort, new RequestParam(), url, new HashMap<String, String>()))), ws -> {
            onOpen.handle(null);
            ws.exceptionHandler(v -> {
                onException.handle(v);
                try {
                    ws.close();
                }
                catch (Exception err) {
                    LOGGER.error("ws close error.", (Throwable)err);
                }
            });
            ws.closeHandler(v -> {
                onClose.handle(v);
                try {
                    ws.close();
                }
                catch (Exception err) {
                    LOGGER.error("ws close error.", (Throwable)err);
                }
            });
            ws.handler(onMessage);
        }, onConnectFailed));
    }
}

