/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.client;

import io.servicecomb.foundation.vertx.AsyncResultCallback;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.api.response.HeartbeatResponse;
import io.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import io.servicecomb.serviceregistry.version.Version;
import io.servicecomb.serviceregistry.version.VersionRule;
import io.servicecomb.serviceregistry.version.VersionRuleUtils;
import io.servicecomb.serviceregistry.version.VersionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class LocalServiceRegistryClientImpl
implements ServiceRegistryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalServiceRegistryClientImpl.class);
    public static final String LOCAL_REGISTRY_FILE_KEY = "local.registry.file";
    private final String LOCAL_REGISTRY_FILE = System.getProperty("local.registry.file");
    private Map<String, Microservice> microserviceIdMap = new ConcurrentHashMap<String, Microservice>();
    private Map<String, Map<String, MicroserviceInstance>> microserviceInstanceMap = new ConcurrentHashMap<String, Map<String, MicroserviceInstance>>();

    public LocalServiceRegistryClientImpl() {
        if (StringUtils.isEmpty((Object)this.LOCAL_REGISTRY_FILE)) {
            LOGGER.info("create empty local registry.");
            return;
        }
        try (FileInputStream is = new FileInputStream(new File(this.LOCAL_REGISTRY_FILE));){
            this.initFromData(is);
        }
        catch (IOException e) {
            LOGGER.error("can not load local registry file:" + this.LOCAL_REGISTRY_FILE, (Throwable)e);
        }
    }

    public LocalServiceRegistryClientImpl(InputStream is) {
        this.initFromData(is);
    }

    public LocalServiceRegistryClientImpl(Map<String, Object> data) {
        this.initFromData(data);
    }

    private void initFromData(InputStream is) {
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.loadAs(is, Map.class);
        this.initFromData(data);
    }

    private void initFromData(Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String name = entry.getKey();
            List serviceConfigs = (List)entry.getValue();
            for (Map serviceConfig : serviceConfigs) {
                List instancesConfig = (List)serviceConfig.get("instances");
                String appId = (String)serviceConfig.get("appid");
                String version = (String)serviceConfig.get("version");
                String serviceId = (String)serviceConfig.get("id");
                Microservice microservice = new Microservice();
                microservice.setAppId(appId == null ? "default" : appId);
                microservice.setServiceName(name);
                microservice.setVersion(version);
                microservice.setServiceId(serviceId == null ? UUID.randomUUID().toString() : serviceId);
                this.microserviceIdMap.put(microservice.getServiceId(), microservice);
                ConcurrentHashMap<String, MicroserviceInstance> instanceMap = new ConcurrentHashMap<String, MicroserviceInstance>();
                for (Map instanceConfig : instancesConfig) {
                    List endpoints = (List)instanceConfig.get("endpoints");
                    MicroserviceInstance instance = new MicroserviceInstance();
                    instance.setInstanceId(UUID.randomUUID().toString());
                    instance.setEndpoints(endpoints);
                    instance.setServiceId(microservice.getServiceId());
                    instanceMap.put(instance.getInstanceId(), instance);
                }
                this.microserviceInstanceMap.put(microservice.getServiceId(), instanceMap);
            }
        }
    }

    @Override
    public void init() {
    }

    @Override
    public List<Microservice> getAllMicroservices() {
        return new ArrayList<Microservice>(this.microserviceIdMap.values());
    }

    @Override
    public String getMicroserviceId(String appId, String microserviceName, String strVersionRule) {
        VersionRule versionRule = VersionRuleUtils.getOrCreate(strVersionRule);
        Microservice latest = this.findLatest(appId, microserviceName, versionRule);
        return latest != null ? latest.getServiceId() : null;
    }

    @Override
    public String registerMicroservice(Microservice microservice) {
        String serviceId = microservice.getServiceId() == null ? UUID.randomUUID().toString() : microservice.getServiceId();
        this.microserviceIdMap.put(serviceId, microservice);
        Map<String, MicroserviceInstance> instanceMap = this.microserviceInstanceMap.get(serviceId);
        if (instanceMap == null) {
            this.microserviceInstanceMap.put(serviceId, new ConcurrentHashMap());
        }
        return serviceId;
    }

    @Override
    public Microservice getMicroservice(String microserviceId) {
        return this.microserviceIdMap.get(microserviceId);
    }

    @Override
    public String registerMicroserviceInstance(MicroserviceInstance instance) {
        Map<String, MicroserviceInstance> instanceMap = this.microserviceInstanceMap.get(instance.getServiceId());
        if (instanceMap == null) {
            throw new IllegalArgumentException("Invalid serviceId of instance, serviceId=" + instance.getServiceId());
        }
        String instanceId = instance.getInstanceId() == null ? UUID.randomUUID().toString() : instance.getInstanceId();
        instanceMap.put(instanceId, instance);
        return instanceId;
    }

    @Override
    public List<MicroserviceInstance> getMicroserviceInstance(String consumerId, String providerId) {
        Map<String, MicroserviceInstance> instanceMap = this.microserviceInstanceMap.get(providerId);
        if (instanceMap == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + providerId);
        }
        return new ArrayList<MicroserviceInstance>(instanceMap.values());
    }

    @Override
    public boolean unregisterMicroserviceInstance(String microserviceId, String microserviceInstanceId) {
        Map<String, MicroserviceInstance> instanceMap = this.microserviceInstanceMap.get(microserviceId);
        if (instanceMap != null) {
            instanceMap.remove(microserviceInstanceId);
        }
        return true;
    }

    @Override
    public HeartbeatResponse heartbeat(String microserviceId, String microserviceInstanceId) {
        HeartbeatResponse response = new HeartbeatResponse();
        response.setMessage("OK");
        response.setOk(true);
        return response;
    }

    @Override
    public void watch(String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback) {
        this.watch(selfMicroserviceId, callback, (AsyncResultCallback<Void>)((AsyncResultCallback)v -> {}), (AsyncResultCallback<Void>)((AsyncResultCallback)v -> {}));
    }

    @Override
    public void watch(String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback, AsyncResultCallback<Void> onOpen, AsyncResultCallback<Void> onClose) {
    }

    protected boolean isSameMicroservice(Microservice microservice, String appId, String serviceName) {
        return microservice.getAppId().equals(appId) && microservice.getServiceName().equals(serviceName);
    }

    protected Microservice findLatest(String appId, String serviceName, VersionRule versionRule) {
        Version latestVersion = null;
        Microservice latest = null;
        for (Map.Entry<String, Microservice> entry : this.microserviceIdMap.entrySet()) {
            Version version;
            Microservice microservice = entry.getValue();
            if (!this.isSameMicroservice(microservice, appId, serviceName) || !versionRule.isAccept(version = VersionUtils.getOrCreate(microservice.getVersion())) || latestVersion != null && version.compareTo(latestVersion) <= 0) continue;
            latestVersion = version;
            latest = microservice;
        }
        return latest;
    }

    @Override
    public List<MicroserviceInstance> findServiceInstance(String selfMicroserviceId, String appId, String serviceName, String strVersionRule) {
        ArrayList<MicroserviceInstance> allInstances = new ArrayList<MicroserviceInstance>();
        VersionRule versionRule = VersionRuleUtils.getOrCreate(strVersionRule);
        Microservice latestMicroservice = this.findLatest(appId, serviceName, versionRule);
        if (latestMicroservice == null) {
            return allInstances;
        }
        Version latestVersion = VersionUtils.getOrCreate(latestMicroservice.getVersion());
        for (Map.Entry<String, Microservice> entry : this.microserviceIdMap.entrySet()) {
            Version version;
            Microservice microservice = entry.getValue();
            if (!this.isSameMicroservice(microservice, appId, serviceName) || !versionRule.isMatch(version = VersionUtils.getOrCreate(entry.getValue().getVersion()), latestVersion)) continue;
            Map<String, MicroserviceInstance> instances = this.microserviceInstanceMap.get(entry.getValue().getServiceId());
            allInstances.addAll(instances.values());
        }
        return allInstances;
    }

    @Override
    public boolean isSchemaExist(String microserviceId, String schemaId) {
        Microservice microservice = this.microserviceIdMap.get(microserviceId);
        if (microservice == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        return microservice.getSchemaMap().containsKey(schemaId);
    }

    @Override
    public boolean registerSchema(String microserviceId, String schemaId, String schemaContent) {
        Microservice microservice = this.microserviceIdMap.get(microserviceId);
        if (microservice == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        microservice.getSchemaMap().put(schemaId, schemaContent);
        return true;
    }

    @Override
    public String getSchema(String microserviceId, String schemaId) {
        Microservice microservice = this.microserviceIdMap.get(microserviceId);
        if (microservice == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        return microservice.getSchemaMap().get(schemaId);
    }

    @Override
    public boolean updateMicroserviceProperties(String microserviceId, Map<String, String> serviceProperties) {
        Microservice microservice = this.microserviceIdMap.get(microserviceId);
        if (microservice == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        if (serviceProperties != null) {
            microservice.getProperties().putAll(serviceProperties);
        }
        return true;
    }

    @Override
    public boolean updateInstanceProperties(String microserviceId, String microserviceInstanceId, Map<String, String> instanceProperties) {
        Map<String, MicroserviceInstance> instanceMap = this.microserviceInstanceMap.get(microserviceId);
        if (instanceMap == null) {
            throw new IllegalArgumentException("Invalid serviceId, serviceId=" + microserviceId);
        }
        MicroserviceInstance microserviceInstance = instanceMap.get(microserviceInstanceId);
        if (microserviceInstance == null) {
            throw new IllegalArgumentException(String.format("Invalid argument. microserviceId=%s, microserviceInstanceId=%s.", microserviceId, microserviceInstanceId));
        }
        if (instanceProperties != null) {
            microserviceInstance.getProperties().putAll(instanceProperties);
        }
        return true;
    }

    @Override
    public MicroserviceInstance findServiceInstance(String serviceId, String instanceId) {
        Map<String, MicroserviceInstance> instances = this.microserviceInstanceMap.get(serviceId);
        return instances.get(instanceId);
    }
}

