/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceInstanceCache {
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceInstanceCache.class);
    private static Cache<String, MicroserviceInstance> instances = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();

    public static MicroserviceInstance getOrCreate(final String serviceId, final String instanceId) {
        try {
            String key = String.format("%s@%s", serviceId, instanceId);
            return (MicroserviceInstance)instances.get((Object)key, (Callable)new Callable<MicroserviceInstance>(){

                @Override
                public MicroserviceInstance call() throws Exception {
                    logger.debug("get microservice instance from SC");
                    return MicroserviceInstanceCache.getMicroserviceInstanceFromSC(serviceId, instanceId);
                }
            });
        }
        catch (ExecutionException e) {
            logger.error("get microservice from cache failed:" + String.format("%s@%s", serviceId, instanceId));
            return null;
        }
    }

    private static MicroserviceInstance getMicroserviceInstanceFromSC(String serviceId, String instanceId) {
        return RegistryUtils.getServiceRegistryClient().findServiceInstance(serviceId, instanceId);
    }
}

