/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.serverlessworkflow.api.produce.ProduceEvent;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.IOException;

public class TransitionSerializer
extends StdSerializer<Transition> {
    public TransitionSerializer() {
        this(Transition.class);
    }

    protected TransitionSerializer(Class<Transition> t) {
        super(t);
    }

    public void serialize(Transition transition, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (transition != null) {
            if (!(transition.getProduceEvents() != null && transition.getProduceEvents().size() >= 1 || transition.isCompensate() || transition.getNextState() == null || transition.getNextState().length() <= 0)) {
                gen.writeString(transition.getNextState());
            } else {
                gen.writeStartObject();
                if (transition.getProduceEvents() != null && !transition.getProduceEvents().isEmpty()) {
                    gen.writeArrayFieldStart("produceEvents");
                    for (ProduceEvent produceEvent : transition.getProduceEvents()) {
                        gen.writeObject((Object)produceEvent);
                    }
                    gen.writeEndArray();
                }
                if (transition.isCompensate()) {
                    gen.writeBooleanField("compensate", true);
                }
                if (transition.getNextState() != null && transition.getNextState().length() > 0) {
                    gen.writeStringField("nextState", transition.getNextState());
                }
                gen.writeEndObject();
            }
        }
    }
}

