/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.mapper;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.serverlessworkflow.api.auth.AuthDefinition;
import io.serverlessworkflow.api.cron.Cron;
import io.serverlessworkflow.api.datainputschema.DataInputSchema;
import io.serverlessworkflow.api.deserializers.AuthDefinitionDeserializer;
import io.serverlessworkflow.api.deserializers.AuthDeserializer;
import io.serverlessworkflow.api.deserializers.ConstantsDeserializer;
import io.serverlessworkflow.api.deserializers.ContinueAsDeserializer;
import io.serverlessworkflow.api.deserializers.CronDeserializer;
import io.serverlessworkflow.api.deserializers.DataInputSchemaDeserializer;
import io.serverlessworkflow.api.deserializers.DefaultStateTypeDeserializer;
import io.serverlessworkflow.api.deserializers.EndDefinitionDeserializer;
import io.serverlessworkflow.api.deserializers.ErrorsDeserializer;
import io.serverlessworkflow.api.deserializers.EventDefinitionKindDeserializer;
import io.serverlessworkflow.api.deserializers.EventsDeserializer;
import io.serverlessworkflow.api.deserializers.ExtensionDeserializer;
import io.serverlessworkflow.api.deserializers.FunctionDefinitionTypeDeserializer;
import io.serverlessworkflow.api.deserializers.FunctionRefDeserializer;
import io.serverlessworkflow.api.deserializers.FunctionsDeserializer;
import io.serverlessworkflow.api.deserializers.OnEventsActionModeDeserializer;
import io.serverlessworkflow.api.deserializers.OperationStateActionModeDeserializer;
import io.serverlessworkflow.api.deserializers.ParallelStateCompletionTypeDeserializer;
import io.serverlessworkflow.api.deserializers.RetriesDeserializer;
import io.serverlessworkflow.api.deserializers.ScheduleDeserializer;
import io.serverlessworkflow.api.deserializers.SecretsDeserializer;
import io.serverlessworkflow.api.deserializers.StartDefinitionDeserializer;
import io.serverlessworkflow.api.deserializers.StateDeserializer;
import io.serverlessworkflow.api.deserializers.StateExecTimeoutDeserializer;
import io.serverlessworkflow.api.deserializers.StringValueDeserializer;
import io.serverlessworkflow.api.deserializers.SubFlowRefDeserializer;
import io.serverlessworkflow.api.deserializers.TransitionDeserializer;
import io.serverlessworkflow.api.end.ContinueAs;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.functions.SubFlowRef;
import io.serverlessworkflow.api.interfaces.Extension;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import io.serverlessworkflow.api.schedule.Schedule;
import io.serverlessworkflow.api.serializers.AuthDefinitionSerializer;
import io.serverlessworkflow.api.serializers.CallbackStateSerializer;
import io.serverlessworkflow.api.serializers.ContinueAsSerializer;
import io.serverlessworkflow.api.serializers.CronSerializer;
import io.serverlessworkflow.api.serializers.EndDefinitionSerializer;
import io.serverlessworkflow.api.serializers.EventStateSerializer;
import io.serverlessworkflow.api.serializers.ExtensionSerializer;
import io.serverlessworkflow.api.serializers.ForEachStateSerializer;
import io.serverlessworkflow.api.serializers.FunctionRefSerializer;
import io.serverlessworkflow.api.serializers.InjectStateSerializer;
import io.serverlessworkflow.api.serializers.OperationStateSerializer;
import io.serverlessworkflow.api.serializers.ParallelStateSerializer;
import io.serverlessworkflow.api.serializers.ScheduleSerializer;
import io.serverlessworkflow.api.serializers.SleepStateSerializer;
import io.serverlessworkflow.api.serializers.StartDefinitionSerializer;
import io.serverlessworkflow.api.serializers.StateExecTimeoutSerializer;
import io.serverlessworkflow.api.serializers.SubFlowRefSerializer;
import io.serverlessworkflow.api.serializers.SwitchStateSerializer;
import io.serverlessworkflow.api.serializers.TransitionSerializer;
import io.serverlessworkflow.api.serializers.WorkflowSerializer;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.states.OperationState;
import io.serverlessworkflow.api.states.ParallelState;
import io.serverlessworkflow.api.timeouts.StateExecTimeout;
import io.serverlessworkflow.api.transitions.Transition;
import io.serverlessworkflow.api.workflow.Auth;
import io.serverlessworkflow.api.workflow.Constants;
import io.serverlessworkflow.api.workflow.Errors;
import io.serverlessworkflow.api.workflow.Events;
import io.serverlessworkflow.api.workflow.Functions;
import io.serverlessworkflow.api.workflow.Retries;
import io.serverlessworkflow.api.workflow.Secrets;

public class WorkflowModule
extends SimpleModule {
    private static final long serialVersionUID = 510L;
    private WorkflowPropertySource workflowPropertySource;
    private ExtensionSerializer extensionSerializer;
    private ExtensionDeserializer extensionDeserializer;

    public WorkflowModule() {
        this(null);
    }

    public WorkflowModule(WorkflowPropertySource workflowPropertySource) {
        super("workflow-module");
        this.workflowPropertySource = workflowPropertySource;
        this.extensionSerializer = new ExtensionSerializer();
        this.extensionDeserializer = new ExtensionDeserializer(workflowPropertySource);
        this.addDefaultSerializers();
        this.addDefaultDeserializers();
    }

    private void addDefaultSerializers() {
        this.addSerializer((JsonSerializer)new WorkflowSerializer());
        this.addSerializer((JsonSerializer)new EventStateSerializer());
        this.addSerializer((JsonSerializer)new SleepStateSerializer());
        this.addSerializer((JsonSerializer)new OperationStateSerializer());
        this.addSerializer((JsonSerializer)new ParallelStateSerializer());
        this.addSerializer((JsonSerializer)new SwitchStateSerializer());
        this.addSerializer((JsonSerializer)new InjectStateSerializer());
        this.addSerializer((JsonSerializer)new ForEachStateSerializer());
        this.addSerializer((JsonSerializer)new CallbackStateSerializer());
        this.addSerializer((JsonSerializer)new StartDefinitionSerializer());
        this.addSerializer((JsonSerializer)new EndDefinitionSerializer());
        this.addSerializer((JsonSerializer)new TransitionSerializer());
        this.addSerializer((JsonSerializer)new FunctionRefSerializer());
        this.addSerializer((JsonSerializer)new CronSerializer());
        this.addSerializer((JsonSerializer)new ScheduleSerializer());
        this.addSerializer((JsonSerializer)new SubFlowRefSerializer());
        this.addSerializer((JsonSerializer)new AuthDefinitionSerializer());
        this.addSerializer((JsonSerializer)new StateExecTimeoutSerializer());
        this.addSerializer((JsonSerializer)new ContinueAsSerializer());
        this.addSerializer((JsonSerializer)this.extensionSerializer);
    }

    private void addDefaultDeserializers() {
        this.addDeserializer(State.class, (JsonDeserializer)new StateDeserializer(this.workflowPropertySource));
        this.addDeserializer(String.class, (JsonDeserializer)new StringValueDeserializer(this.workflowPropertySource));
        this.addDeserializer(OnEvents.ActionMode.class, (JsonDeserializer)new OnEventsActionModeDeserializer(this.workflowPropertySource));
        this.addDeserializer(OperationState.ActionMode.class, (JsonDeserializer)new OperationStateActionModeDeserializer(this.workflowPropertySource));
        this.addDeserializer(DefaultState.Type.class, (JsonDeserializer)new DefaultStateTypeDeserializer(this.workflowPropertySource));
        this.addDeserializer(EventDefinition.Kind.class, (JsonDeserializer)new EventDefinitionKindDeserializer(this.workflowPropertySource));
        this.addDeserializer(ParallelState.CompletionType.class, (JsonDeserializer)new ParallelStateCompletionTypeDeserializer(this.workflowPropertySource));
        this.addDeserializer(Retries.class, (JsonDeserializer)new RetriesDeserializer(this.workflowPropertySource));
        this.addDeserializer(Secrets.class, (JsonDeserializer)new SecretsDeserializer(this.workflowPropertySource));
        this.addDeserializer(Constants.class, (JsonDeserializer)new ConstantsDeserializer(this.workflowPropertySource));
        this.addDeserializer(Functions.class, (JsonDeserializer)new FunctionsDeserializer(this.workflowPropertySource));
        this.addDeserializer(Events.class, (JsonDeserializer)new EventsDeserializer(this.workflowPropertySource));
        this.addDeserializer(Start.class, (JsonDeserializer)new StartDefinitionDeserializer(this.workflowPropertySource));
        this.addDeserializer(End.class, (JsonDeserializer)new EndDefinitionDeserializer(this.workflowPropertySource));
        this.addDeserializer(Extension.class, (JsonDeserializer)this.extensionDeserializer);
        this.addDeserializer(FunctionDefinition.Type.class, (JsonDeserializer)new FunctionDefinitionTypeDeserializer(this.workflowPropertySource));
        this.addDeserializer(Transition.class, (JsonDeserializer)new TransitionDeserializer(this.workflowPropertySource));
        this.addDeserializer(FunctionRef.class, (JsonDeserializer)new FunctionRefDeserializer(this.workflowPropertySource));
        this.addDeserializer(SubFlowRef.class, (JsonDeserializer)new SubFlowRefDeserializer(this.workflowPropertySource));
        this.addDeserializer(Cron.class, (JsonDeserializer)new CronDeserializer(this.workflowPropertySource));
        this.addDeserializer(Schedule.class, (JsonDeserializer)new ScheduleDeserializer(this.workflowPropertySource));
        this.addDeserializer(DataInputSchema.class, (JsonDeserializer)new DataInputSchemaDeserializer(this.workflowPropertySource));
        this.addDeserializer(AuthDefinition.class, (JsonDeserializer)new AuthDefinitionDeserializer(this.workflowPropertySource));
        this.addDeserializer(StateExecTimeout.class, (JsonDeserializer)new StateExecTimeoutDeserializer(this.workflowPropertySource));
        this.addDeserializer(Errors.class, (JsonDeserializer)new ErrorsDeserializer(this.workflowPropertySource));
        this.addDeserializer(ContinueAs.class, (JsonDeserializer)new ContinueAsDeserializer(this.workflowPropertySource));
        this.addDeserializer(Auth.class, (JsonDeserializer)new AuthDeserializer(this.workflowPropertySource));
    }

    public ExtensionSerializer getExtensionSerializer() {
        return this.extensionSerializer;
    }

    public ExtensionDeserializer getExtensionDeserializer() {
        return this.extensionDeserializer;
    }
}

