/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.functions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "operation", "type", "authRef", "metadata"})
public class FunctionDefinition
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Function unique name")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="operation")
    @JsonPropertyDescription(value="If type is `rest`, <path_to_openapi_definition>#<operation_id>. If type is `rpc`, <path_to_grpc_proto_file>#<service_name>#<service_method>. If type is `expression`, defines the workflow expression.")
    @Size(min=1)
    private @Size(min=1) String operation;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Defines the function type. Is either `rest`, `asyncapi, `rpc`, `graphql`, `odata`, `expression`, or `custom`. Default is `rest`")
    private Type type = Type.fromValue("rest");
    @JsonProperty(value="authRef")
    @JsonPropertyDescription(value="References an auth definition name to be used to access to resource defined in the operation parameter")
    @Size(min=1)
    private @Size(min=1) String authRef;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    private static final long serialVersionUID = -8792630341762512097L;

    public FunctionDefinition() {
    }

    public FunctionDefinition(String name) {
        this.name = name;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public FunctionDefinition withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="operation")
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public FunctionDefinition withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public FunctionDefinition withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="authRef")
    public String getAuthRef() {
        return this.authRef;
    }

    @JsonProperty(value="authRef")
    public void setAuthRef(String authRef) {
        this.authRef = authRef;
    }

    public FunctionDefinition withAuthRef(String authRef) {
        this.authRef = authRef;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public FunctionDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public static enum Type {
        REST("rest"),
        ASYNCAPI("asyncapi"),
        RPC("rpc"),
        GRAPHQL("graphql"),
        ODATA("odata"),
        EXPRESSION("expression"),
        CUSTOM("custom");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

