/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.error;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.transitions.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"errorRef", "errorRefs", "transition", "end"})
public class Error
implements Serializable {
    @JsonProperty(value="errorRef")
    @JsonPropertyDescription(value="Reference to a unique workflow error definition. Used of errorRefs is not used")
    @Size(min=1)
    private @Size(min=1) String errorRef;
    @JsonProperty(value="errorRefs")
    @JsonPropertyDescription(value="References one or more workflow error definitions. Used if errorRef is not used")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<String> errorRefs = new ArrayList<String>();
    @JsonProperty(value="transition")
    @Valid
    @NotNull
    private Transition transition;
    @JsonProperty(value="end")
    @JsonPropertyDescription(value="State end definition")
    @Valid
    private End end;
    private static final long serialVersionUID = -5942415987505171493L;

    public Error() {
    }

    public Error(Transition transition) {
        this.transition = transition;
    }

    @JsonProperty(value="errorRef")
    public String getErrorRef() {
        return this.errorRef;
    }

    @JsonProperty(value="errorRef")
    public void setErrorRef(String errorRef) {
        this.errorRef = errorRef;
    }

    public Error withErrorRef(String errorRef) {
        this.errorRef = errorRef;
        return this;
    }

    @JsonProperty(value="errorRefs")
    public List<String> getErrorRefs() {
        return this.errorRefs;
    }

    @JsonProperty(value="errorRefs")
    public void setErrorRefs(List<String> errorRefs) {
        this.errorRefs = errorRefs;
    }

    public Error withErrorRefs(List<String> errorRefs) {
        this.errorRefs = errorRefs;
        return this;
    }

    @JsonProperty(value="transition")
    public Transition getTransition() {
        return this.transition;
    }

    @JsonProperty(value="transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public Error withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    @JsonProperty(value="end")
    public End getEnd() {
        return this.end;
    }

    @JsonProperty(value="end")
    public void setEnd(End end) {
        this.end = end;
    }

    public Error withEnd(End end) {
        this.end = end;
        return this;
    }
}

