/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.interfaces.WorkflowPropertySource;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionDefinitionTypeDeserializer
extends StdDeserializer<FunctionDefinition.Type> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(FunctionDefinitionTypeDeserializer.class);
    private WorkflowPropertySource context;

    public FunctionDefinitionTypeDeserializer() {
        this(FunctionDefinition.Type.class);
    }

    public FunctionDefinitionTypeDeserializer(WorkflowPropertySource context) {
        this(FunctionDefinition.Type.class);
        this.context = context;
    }

    public FunctionDefinitionTypeDeserializer(Class<?> vc) {
        super(vc);
    }

    public FunctionDefinition.Type deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return FunctionDefinition.Type.fromValue(result);
                }
                return FunctionDefinition.Type.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return FunctionDefinition.Type.fromValue(jp.getText());
            }
        }
        return FunctionDefinition.Type.fromValue(jp.getText());
    }
}

