/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"authority", "grantType", "clientId", "clientSecret", "scopes", "username", "password", "audiences", "subjectToken", "requestedSubject", "requestedIssuer", "metadata"})
public class OauthDefinition
implements Serializable {
    @JsonProperty(value="authority")
    @JsonPropertyDescription(value="String or a workflow expression. Contains the authority information")
    @Size(min=1)
    private @Size(min=1) String authority;
    @JsonProperty(value="grantType")
    @JsonPropertyDescription(value="Defines the grant type")
    @NotNull
    private GrantType grantType;
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="String or a workflow expression. Contains the client identifier")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String clientId;
    @JsonProperty(value="clientSecret")
    @JsonPropertyDescription(value="Workflow secret or a workflow expression. Contains the client secret")
    @Size(min=1)
    private @Size(min=1) String clientSecret;
    @JsonProperty(value="scopes")
    @JsonPropertyDescription(value="Array containing strings or workflow expressions. Contains the OAuth2 scopes")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<String> scopes = new ArrayList<String>();
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="String or a workflow expression. Contains the user name. Used only if grantType is 'resourceOwner'")
    @Size(min=1)
    private @Size(min=1) String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="String or a workflow expression. Contains the user password. Used only if grantType is 'resourceOwner'")
    @Size(min=1)
    private @Size(min=1) String password;
    @JsonProperty(value="audiences")
    @JsonPropertyDescription(value="Array containing strings or workflow expressions. Contains the OAuth2 audiences")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<String> audiences = new ArrayList<String>();
    @JsonProperty(value="subjectToken")
    @JsonPropertyDescription(value="String or a workflow expression. Contains the subject token")
    @Size(min=1)
    private @Size(min=1) String subjectToken;
    @JsonProperty(value="requestedSubject")
    @JsonPropertyDescription(value="String or a workflow expression. Contains the requested subject")
    @Size(min=1)
    private @Size(min=1) String requestedSubject;
    @JsonProperty(value="requestedIssuer")
    @JsonPropertyDescription(value="String or a workflow expression. Contains the requested issuer")
    @Size(min=1)
    private @Size(min=1) String requestedIssuer;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    private static final long serialVersionUID = -1012409488046582753L;

    public OauthDefinition() {
    }

    public OauthDefinition(GrantType grantType, String clientId) {
        this.grantType = grantType;
        this.clientId = clientId;
    }

    @JsonProperty(value="authority")
    public String getAuthority() {
        return this.authority;
    }

    @JsonProperty(value="authority")
    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public OauthDefinition withAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    @JsonProperty(value="grantType")
    public void setGrantType(GrantType grantType) {
        this.grantType = grantType;
    }

    public OauthDefinition withGrantType(GrantType grantType) {
        this.grantType = grantType;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OauthDefinition withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="clientSecret")
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OauthDefinition withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @JsonProperty(value="scopes")
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public OauthDefinition withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public OauthDefinition withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public OauthDefinition withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="audiences")
    public List<String> getAudiences() {
        return this.audiences;
    }

    @JsonProperty(value="audiences")
    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public OauthDefinition withAudiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    @JsonProperty(value="subjectToken")
    public String getSubjectToken() {
        return this.subjectToken;
    }

    @JsonProperty(value="subjectToken")
    public void setSubjectToken(String subjectToken) {
        this.subjectToken = subjectToken;
    }

    public OauthDefinition withSubjectToken(String subjectToken) {
        this.subjectToken = subjectToken;
        return this;
    }

    @JsonProperty(value="requestedSubject")
    public String getRequestedSubject() {
        return this.requestedSubject;
    }

    @JsonProperty(value="requestedSubject")
    public void setRequestedSubject(String requestedSubject) {
        this.requestedSubject = requestedSubject;
    }

    public OauthDefinition withRequestedSubject(String requestedSubject) {
        this.requestedSubject = requestedSubject;
        return this;
    }

    @JsonProperty(value="requestedIssuer")
    public String getRequestedIssuer() {
        return this.requestedIssuer;
    }

    @JsonProperty(value="requestedIssuer")
    public void setRequestedIssuer(String requestedIssuer) {
        this.requestedIssuer = requestedIssuer;
    }

    public OauthDefinition withRequestedIssuer(String requestedIssuer) {
        this.requestedIssuer = requestedIssuer;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public OauthDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public static enum GrantType {
        PASSWORD("password"),
        CLIENT_CREDENTIALS("clientCredentials"),
        TOKEN_EXCHANGE("tokenExchange");

        private final String value;
        private static final Map<String, GrantType> CONSTANTS;

        private GrantType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static GrantType fromValue(String value) {
            GrantType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, GrantType>();
            for (GrantType c : GrantType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

