/*
 * Decompiled with CFR 0.152.
 */
package io.serverlessworkflow.api.actions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.events.EventRef;
import io.serverlessworkflow.api.filters.ActionDataFilter;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.functions.SubFlowRef;
import io.serverlessworkflow.api.sleep.Sleep;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "functionRef", "eventRef", "subFlowRef", "sleep", "retryRef", "nonRetryableErrors", "retryableErrors", "actionDataFilter", "condition"})
public class Action
implements Serializable {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique action identifier")
    private String id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Unique action definition name")
    private String name;
    @JsonProperty(value="functionRef")
    @Valid
    private FunctionRef functionRef;
    @JsonProperty(value="eventRef")
    @JsonPropertyDescription(value="Event References")
    @Valid
    private EventRef eventRef;
    @JsonProperty(value="subFlowRef")
    @Valid
    private SubFlowRef subFlowRef;
    @JsonProperty(value="sleep")
    @Valid
    private Sleep sleep;
    @JsonProperty(value="retryRef")
    @JsonPropertyDescription(value="References a defined workflow retry definition. If not defined the default retry policy is assumed")
    private String retryRef;
    @JsonProperty(value="nonRetryableErrors")
    @JsonPropertyDescription(value="List of unique references to defined workflow errors for which the action should not be retried. Used only when `autoRetries` is set to `true`")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<String> nonRetryableErrors = new ArrayList<String>();
    @JsonProperty(value="retryableErrors")
    @JsonPropertyDescription(value="List of unique references to defined workflow errors for which the action should be retried. Used only when `autoRetries` is set to `false`")
    @Size(min=1)
    @Valid
    private @Size(min=1) @Valid List<String> retryableErrors = new ArrayList<String>();
    @JsonProperty(value="actionDataFilter")
    @Valid
    private ActionDataFilter actionDataFilter;
    @JsonProperty(value="condition")
    @JsonPropertyDescription(value="Expression, if defined, must evaluate to true for this action to be performed. If false, action is disregarded")
    @Size(min=1)
    private @Size(min=1) String condition;
    private static final long serialVersionUID = 5349382716473763088L;

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Action withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Action withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="functionRef")
    public FunctionRef getFunctionRef() {
        return this.functionRef;
    }

    @JsonProperty(value="functionRef")
    public void setFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
    }

    public Action withFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
        return this;
    }

    @JsonProperty(value="eventRef")
    public EventRef getEventRef() {
        return this.eventRef;
    }

    @JsonProperty(value="eventRef")
    public void setEventRef(EventRef eventRef) {
        this.eventRef = eventRef;
    }

    public Action withEventRef(EventRef eventRef) {
        this.eventRef = eventRef;
        return this;
    }

    @JsonProperty(value="subFlowRef")
    public SubFlowRef getSubFlowRef() {
        return this.subFlowRef;
    }

    @JsonProperty(value="subFlowRef")
    public void setSubFlowRef(SubFlowRef subFlowRef) {
        this.subFlowRef = subFlowRef;
    }

    public Action withSubFlowRef(SubFlowRef subFlowRef) {
        this.subFlowRef = subFlowRef;
        return this;
    }

    @JsonProperty(value="sleep")
    public Sleep getSleep() {
        return this.sleep;
    }

    @JsonProperty(value="sleep")
    public void setSleep(Sleep sleep) {
        this.sleep = sleep;
    }

    public Action withSleep(Sleep sleep) {
        this.sleep = sleep;
        return this;
    }

    @JsonProperty(value="retryRef")
    public String getRetryRef() {
        return this.retryRef;
    }

    @JsonProperty(value="retryRef")
    public void setRetryRef(String retryRef) {
        this.retryRef = retryRef;
    }

    public Action withRetryRef(String retryRef) {
        this.retryRef = retryRef;
        return this;
    }

    @JsonProperty(value="nonRetryableErrors")
    public List<String> getNonRetryableErrors() {
        return this.nonRetryableErrors;
    }

    @JsonProperty(value="nonRetryableErrors")
    public void setNonRetryableErrors(List<String> nonRetryableErrors) {
        this.nonRetryableErrors = nonRetryableErrors;
    }

    public Action withNonRetryableErrors(List<String> nonRetryableErrors) {
        this.nonRetryableErrors = nonRetryableErrors;
        return this;
    }

    @JsonProperty(value="retryableErrors")
    public List<String> getRetryableErrors() {
        return this.retryableErrors;
    }

    @JsonProperty(value="retryableErrors")
    public void setRetryableErrors(List<String> retryableErrors) {
        this.retryableErrors = retryableErrors;
    }

    public Action withRetryableErrors(List<String> retryableErrors) {
        this.retryableErrors = retryableErrors;
        return this;
    }

    @JsonProperty(value="actionDataFilter")
    public ActionDataFilter getActionDataFilter() {
        return this.actionDataFilter;
    }

    @JsonProperty(value="actionDataFilter")
    public void setActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
    }

    public Action withActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
        return this;
    }

    @JsonProperty(value="condition")
    public String getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Action withCondition(String condition) {
        this.condition = condition;
        return this;
    }
}

