
package io.serverlessworkflow.api.timeouts;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Timeouts Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "workflowExecTimeout",
    "stateExecTimeout",
    "actionExecTimeout",
    "branchExecTimeout",
    "eventTimeout"
})
public class TimeoutsDefinition implements Serializable
{

    @JsonProperty("workflowExecTimeout")
    @Valid
    private WorkflowExecTimeout workflowExecTimeout;
    @JsonProperty("stateExecTimeout")
    @Valid
    private StateExecTimeout stateExecTimeout;
    /**
     * Single actions definition execution timeout duration (ISO 8601 duration format)
     * 
     */
    @JsonProperty("actionExecTimeout")
    @JsonPropertyDescription("Single actions definition execution timeout duration (ISO 8601 duration format)")
    @Size(min = 1)
    private String actionExecTimeout;
    /**
     * Single branch execution timeout duration (ISO 8601 duration format)
     * 
     */
    @JsonProperty("branchExecTimeout")
    @JsonPropertyDescription("Single branch execution timeout duration (ISO 8601 duration format)")
    @Size(min = 1)
    private String branchExecTimeout;
    /**
     * Timeout duration to wait for consuming defined events (ISO 8601 duration format)
     * 
     */
    @JsonProperty("eventTimeout")
    @JsonPropertyDescription("Timeout duration to wait for consuming defined events (ISO 8601 duration format)")
    @Size(min = 1)
    private String eventTimeout;
    private final static long serialVersionUID = -510823631638536253L;

    @JsonProperty("workflowExecTimeout")
    public WorkflowExecTimeout getWorkflowExecTimeout() {
        return workflowExecTimeout;
    }

    @JsonProperty("workflowExecTimeout")
    public void setWorkflowExecTimeout(WorkflowExecTimeout workflowExecTimeout) {
        this.workflowExecTimeout = workflowExecTimeout;
    }

    public TimeoutsDefinition withWorkflowExecTimeout(WorkflowExecTimeout workflowExecTimeout) {
        this.workflowExecTimeout = workflowExecTimeout;
        return this;
    }

    @JsonProperty("stateExecTimeout")
    public StateExecTimeout getStateExecTimeout() {
        return stateExecTimeout;
    }

    @JsonProperty("stateExecTimeout")
    public void setStateExecTimeout(StateExecTimeout stateExecTimeout) {
        this.stateExecTimeout = stateExecTimeout;
    }

    public TimeoutsDefinition withStateExecTimeout(StateExecTimeout stateExecTimeout) {
        this.stateExecTimeout = stateExecTimeout;
        return this;
    }

    /**
     * Single actions definition execution timeout duration (ISO 8601 duration format)
     * 
     */
    @JsonProperty("actionExecTimeout")
    public String getActionExecTimeout() {
        return actionExecTimeout;
    }

    /**
     * Single actions definition execution timeout duration (ISO 8601 duration format)
     * 
     */
    @JsonProperty("actionExecTimeout")
    public void setActionExecTimeout(String actionExecTimeout) {
        this.actionExecTimeout = actionExecTimeout;
    }

    public TimeoutsDefinition withActionExecTimeout(String actionExecTimeout) {
        this.actionExecTimeout = actionExecTimeout;
        return this;
    }

    /**
     * Single branch execution timeout duration (ISO 8601 duration format)
     * 
     */
    @JsonProperty("branchExecTimeout")
    public String getBranchExecTimeout() {
        return branchExecTimeout;
    }

    /**
     * Single branch execution timeout duration (ISO 8601 duration format)
     * 
     */
    @JsonProperty("branchExecTimeout")
    public void setBranchExecTimeout(String branchExecTimeout) {
        this.branchExecTimeout = branchExecTimeout;
    }

    public TimeoutsDefinition withBranchExecTimeout(String branchExecTimeout) {
        this.branchExecTimeout = branchExecTimeout;
        return this;
    }

    /**
     * Timeout duration to wait for consuming defined events (ISO 8601 duration format)
     * 
     */
    @JsonProperty("eventTimeout")
    public String getEventTimeout() {
        return eventTimeout;
    }

    /**
     * Timeout duration to wait for consuming defined events (ISO 8601 duration format)
     * 
     */
    @JsonProperty("eventTimeout")
    public void setEventTimeout(String eventTimeout) {
        this.eventTimeout = eventTimeout;
    }

    public TimeoutsDefinition withEventTimeout(String eventTimeout) {
        this.eventTimeout = eventTimeout;
        return this;
    }

}
