
package io.serverlessworkflow.api.timeouts;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "single",
    "total"
})
public class StateExecTimeout implements Serializable
{

    /**
     * Single state execution timeout, not including retries (ISO 8601 duration format)
     * 
     */
    @JsonProperty("single")
    @JsonPropertyDescription("Single state execution timeout, not including retries (ISO 8601 duration format)")
    @Size(min = 1)
    private String single;
    /**
     * Total state execution timeout, including retries (ISO 8601 duration format)
     * (Required)
     * 
     */
    @JsonProperty("total")
    @JsonPropertyDescription("Total state execution timeout, including retries (ISO 8601 duration format)")
    @Size(min = 1)
    @NotNull
    private String total;
    private final static long serialVersionUID = -1229552954291556442L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StateExecTimeout() {
    }

    /**
     * 
     * @param total
     */
    public StateExecTimeout(String total) {
        super();
        this.total = total;
    }

    /**
     * Single state execution timeout, not including retries (ISO 8601 duration format)
     * 
     */
    @JsonProperty("single")
    public String getSingle() {
        return single;
    }

    /**
     * Single state execution timeout, not including retries (ISO 8601 duration format)
     * 
     */
    @JsonProperty("single")
    public void setSingle(String single) {
        this.single = single;
    }

    public StateExecTimeout withSingle(String single) {
        this.single = single;
        return this;
    }

    /**
     * Total state execution timeout, including retries (ISO 8601 duration format)
     * (Required)
     * 
     */
    @JsonProperty("total")
    public String getTotal() {
        return total;
    }

    /**
     * Total state execution timeout, including retries (ISO 8601 duration format)
     * (Required)
     * 
     */
    @JsonProperty("total")
    public void setTotal(String total) {
        this.total = total;
    }

    public StateExecTimeout withTotal(String total) {
        this.total = total;
        return this;
    }

}
