
package io.serverlessworkflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.defaultdef.DefaultConditionDefinition;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.switchconditions.DataCondition;
import io.serverlessworkflow.api.switchconditions.EventCondition;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * Permits transitions to other states based on criteria matching
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "eventConditions",
    "dataConditions",
    "defaultCondition",
    "usedForCompensation"
})
public class SwitchState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Defines conditions evaluated against events
     * 
     */
    @JsonProperty("eventConditions")
    @JsonPropertyDescription("Defines conditions evaluated against events")
    @Valid
    private List<EventCondition> eventConditions = new ArrayList<EventCondition>();
    /**
     * Defines conditions evaluated against state data
     * 
     */
    @JsonProperty("dataConditions")
    @JsonPropertyDescription("Defines conditions evaluated against state data")
    @Valid
    private List<DataCondition> dataConditions = new ArrayList<DataCondition>();
    /**
     * Switch state default condition definition
     * 
     */
    @JsonProperty("defaultCondition")
    @JsonPropertyDescription("Switch state default condition definition")
    @Valid
    private DefaultConditionDefinition defaultCondition;
    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    @JsonPropertyDescription("If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private final static long serialVersionUID = 6383799176661595489L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SwitchState() {
    }

    /**
     * 
     * @param name
     * @param type
     */
    public SwitchState(java.lang.String name, DefaultState.Type type) {
        super(name, type);
    }

    /**
     * Defines conditions evaluated against events
     * 
     */
    @JsonProperty("eventConditions")
    public List<EventCondition> getEventConditions() {
        return eventConditions;
    }

    /**
     * Defines conditions evaluated against events
     * 
     */
    @JsonProperty("eventConditions")
    public void setEventConditions(List<EventCondition> eventConditions) {
        this.eventConditions = eventConditions;
    }

    public SwitchState withEventConditions(List<EventCondition> eventConditions) {
        this.eventConditions = eventConditions;
        return this;
    }

    /**
     * Defines conditions evaluated against state data
     * 
     */
    @JsonProperty("dataConditions")
    public List<DataCondition> getDataConditions() {
        return dataConditions;
    }

    /**
     * Defines conditions evaluated against state data
     * 
     */
    @JsonProperty("dataConditions")
    public void setDataConditions(List<DataCondition> dataConditions) {
        this.dataConditions = dataConditions;
    }

    public SwitchState withDataConditions(List<DataCondition> dataConditions) {
        this.dataConditions = dataConditions;
        return this;
    }

    /**
     * Switch state default condition definition
     * 
     */
    @JsonProperty("defaultCondition")
    public DefaultConditionDefinition getDefaultCondition() {
        return defaultCondition;
    }

    /**
     * Switch state default condition definition
     * 
     */
    @JsonProperty("defaultCondition")
    public void setDefaultCondition(DefaultConditionDefinition defaultCondition) {
        this.defaultCondition = defaultCondition;
    }

    public SwitchState withDefaultCondition(DefaultConditionDefinition defaultCondition) {
        this.defaultCondition = defaultCondition;
        return this;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public boolean isUsedForCompensation() {
        return usedForCompensation;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public SwitchState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public SwitchState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SwitchState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SwitchState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public SwitchState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public SwitchState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public SwitchState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public SwitchState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public SwitchState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public SwitchState withCompensatedBy(java.lang.String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

    @Override
    public SwitchState withTimeouts(TimeoutsDefinition timeouts) {
        super.withTimeouts(timeouts);
        return this;
    }

}
