
package io.serverlessworkflow.api.states;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * This state is used to wait for events from event sources and then transitioning to a next state
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "duration",
    "usedForCompensation"
})
public class SleepState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Duration (ISO 8601 duration format) to sleep
     * (Required)
     * 
     */
    @JsonProperty("duration")
    @JsonPropertyDescription("Duration (ISO 8601 duration format) to sleep")
    @NotNull
    private java.lang.String duration;
    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    @JsonPropertyDescription("If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private final static long serialVersionUID = -8925446143263030025L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SleepState() {
    }

    /**
     * 
     * @param duration
     * @param name
     * @param type
     */
    public SleepState(java.lang.String duration, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.duration = duration;
    }

    /**
     * Duration (ISO 8601 duration format) to sleep
     * (Required)
     * 
     */
    @JsonProperty("duration")
    public java.lang.String getDuration() {
        return duration;
    }

    /**
     * Duration (ISO 8601 duration format) to sleep
     * (Required)
     * 
     */
    @JsonProperty("duration")
    public void setDuration(java.lang.String duration) {
        this.duration = duration;
    }

    public SleepState withDuration(java.lang.String duration) {
        this.duration = duration;
        return this;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public boolean isUsedForCompensation() {
        return usedForCompensation;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public SleepState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public SleepState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public SleepState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SleepState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public SleepState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public SleepState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public SleepState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public SleepState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public SleepState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public SleepState withCompensatedBy(java.lang.String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

    @Override
    public SleepState withTimeouts(TimeoutsDefinition timeouts) {
        super.withTimeouts(timeouts);
        return this;
    }

}
