
package io.serverlessworkflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.serverlessworkflow.api.branches.Branch;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * Consists of a number of states that are executed in parallel
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "branches",
    "completionType",
    "numCompleted",
    "usedForCompensation"
})
public class ParallelState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Branch Definitions
     * (Required)
     * 
     */
    @JsonProperty("branches")
    @JsonPropertyDescription("Branch Definitions")
    @Valid
    @NotNull
    private List<Branch> branches = new ArrayList<Branch>();
    /**
     * Option types on how to complete branch execution.
     * 
     */
    @JsonProperty("completionType")
    @JsonPropertyDescription("Option types on how to complete branch execution.")
    private ParallelState.CompletionType completionType = ParallelState.CompletionType.fromValue("allOf");
    /**
     * Used when completionType is set to 'atLeast' to specify the minimum number of branches that must complete before the state will transition.
     * 
     */
    @JsonProperty("numCompleted")
    @JsonPropertyDescription("Used when completionType is set to 'atLeast' to specify the minimum number of branches that must complete before the state will transition.")
    private java.lang.String numCompleted = "0";
    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    @JsonPropertyDescription("If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private final static long serialVersionUID = 4190631255619092420L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ParallelState() {
    }

    /**
     * 
     * @param name
     * @param branches
     * @param type
     */
    public ParallelState(List<Branch> branches, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.branches = branches;
    }

    /**
     * Branch Definitions
     * (Required)
     * 
     */
    @JsonProperty("branches")
    public List<Branch> getBranches() {
        return branches;
    }

    /**
     * Branch Definitions
     * (Required)
     * 
     */
    @JsonProperty("branches")
    public void setBranches(List<Branch> branches) {
        this.branches = branches;
    }

    public ParallelState withBranches(List<Branch> branches) {
        this.branches = branches;
        return this;
    }

    /**
     * Option types on how to complete branch execution.
     * 
     */
    @JsonProperty("completionType")
    public ParallelState.CompletionType getCompletionType() {
        return completionType;
    }

    /**
     * Option types on how to complete branch execution.
     * 
     */
    @JsonProperty("completionType")
    public void setCompletionType(ParallelState.CompletionType completionType) {
        this.completionType = completionType;
    }

    public ParallelState withCompletionType(ParallelState.CompletionType completionType) {
        this.completionType = completionType;
        return this;
    }

    /**
     * Used when completionType is set to 'atLeast' to specify the minimum number of branches that must complete before the state will transition.
     * 
     */
    @JsonProperty("numCompleted")
    public java.lang.String getNumCompleted() {
        return numCompleted;
    }

    /**
     * Used when completionType is set to 'atLeast' to specify the minimum number of branches that must complete before the state will transition.
     * 
     */
    @JsonProperty("numCompleted")
    public void setNumCompleted(java.lang.String numCompleted) {
        this.numCompleted = numCompleted;
    }

    public ParallelState withNumCompleted(java.lang.String numCompleted) {
        this.numCompleted = numCompleted;
        return this;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public boolean isUsedForCompensation() {
        return usedForCompensation;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public ParallelState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public ParallelState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ParallelState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ParallelState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ParallelState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ParallelState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ParallelState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ParallelState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ParallelState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public ParallelState withCompensatedBy(java.lang.String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

    @Override
    public ParallelState withTimeouts(TimeoutsDefinition timeouts) {
        super.withTimeouts(timeouts);
        return this;
    }

    public enum CompletionType {

        ALL_OF("allOf"),
        AT_LEAST("atLeast");
        private final java.lang.String value;
        private final static Map<java.lang.String, ParallelState.CompletionType> CONSTANTS = new HashMap<java.lang.String, ParallelState.CompletionType>();

        static {
            for (ParallelState.CompletionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private CompletionType(java.lang.String value) {
            this.value = value;
        }

        @Override
        public java.lang.String toString() {
            return this.value;
        }

        @JsonValue
        public java.lang.String value() {
            return this.value;
        }

        @JsonCreator
        public static ParallelState.CompletionType fromValue(java.lang.String value) {
            ParallelState.CompletionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
