
package io.serverlessworkflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.events.OnEvents;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.timeouts.TimeoutsDefinition;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * This state is used to wait for events from event sources and then to invoke one or more functions to run in sequence or in parallel.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "exclusive",
    "onEvents"
})
public class EventState
    extends DefaultState
    implements Serializable, State
{

    /**
     * If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed
     * 
     */
    @JsonProperty("exclusive")
    @JsonPropertyDescription("If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed")
    private boolean exclusive = true;
    /**
     * Define what events trigger one or more actions to be performed
     * 
     */
    @JsonProperty("onEvents")
    @JsonPropertyDescription("Define what events trigger one or more actions to be performed")
    @Valid
    private List<OnEvents> onEvents = new ArrayList<OnEvents>();
    private final static long serialVersionUID = -3502136740903800687L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventState() {
    }

    /**
     * 
     * @param name
     * @param type
     */
    public EventState(java.lang.String name, DefaultState.Type type) {
        super(name, type);
    }

    /**
     * If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed
     * 
     */
    @JsonProperty("exclusive")
    public boolean isExclusive() {
        return exclusive;
    }

    /**
     * If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed
     * 
     */
    @JsonProperty("exclusive")
    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public EventState withExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    /**
     * Define what events trigger one or more actions to be performed
     * 
     */
    @JsonProperty("onEvents")
    public List<OnEvents> getOnEvents() {
        return onEvents;
    }

    /**
     * Define what events trigger one or more actions to be performed
     * 
     */
    @JsonProperty("onEvents")
    public void setOnEvents(List<OnEvents> onEvents) {
        this.onEvents = onEvents;
    }

    public EventState withOnEvents(List<OnEvents> onEvents) {
        this.onEvents = onEvents;
        return this;
    }

    @Override
    public EventState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public EventState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public EventState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public EventState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public EventState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public EventState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public EventState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public EventState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public EventState withCompensatedBy(java.lang.String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

    @Override
    public EventState withTimeouts(TimeoutsDefinition timeouts) {
        super.withTimeouts(timeouts);
        return this;
    }

}
