
package io.serverlessworkflow.api.start;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.schedule.Schedule;


/**
 * State start definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "stateName",
    "schedule"
})
public class Start implements Serializable
{

    /**
     * Name of the starting workflow state
     * 
     */
    @JsonProperty("stateName")
    @JsonPropertyDescription("Name of the starting workflow state")
    @Size(min = 1)
    private String stateName;
    /**
     * Start state schedule definition
     * 
     */
    @JsonProperty("schedule")
    @JsonPropertyDescription("Start state schedule definition")
    @Valid
    private Schedule schedule;
    private final static long serialVersionUID = -523611139255478407L;

    /**
     * Name of the starting workflow state
     * 
     */
    @JsonProperty("stateName")
    public String getStateName() {
        return stateName;
    }

    /**
     * Name of the starting workflow state
     * 
     */
    @JsonProperty("stateName")
    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public Start withStateName(String stateName) {
        this.stateName = stateName;
        return this;
    }

    /**
     * Start state schedule definition
     * 
     */
    @JsonProperty("schedule")
    public Schedule getSchedule() {
        return schedule;
    }

    /**
     * Start state schedule definition
     * 
     */
    @JsonProperty("schedule")
    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public Start withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

}
