
package io.serverlessworkflow.api.schedule;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.cron.Cron;


/**
 * Start state schedule definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "interval",
    "cron",
    "timezone"
})
public class Schedule implements Serializable
{

    /**
     * Time interval (ISO 8601 format) describing when the workflow starting state is active
     * 
     */
    @JsonProperty("interval")
    @JsonPropertyDescription("Time interval (ISO 8601 format) describing when the workflow starting state is active")
    private String interval;
    /**
     * Schedule cron definition
     * 
     */
    @JsonProperty("cron")
    @JsonPropertyDescription("Schedule cron definition")
    @Valid
    private Cron cron;
    /**
     * Timezone name used to evaluate the cron expression. Not used for interval as timezone can be specified there directly. If not specified, should default to local machine timezone.
     * 
     */
    @JsonProperty("timezone")
    @JsonPropertyDescription("Timezone name used to evaluate the cron expression. Not used for interval as timezone can be specified there directly. If not specified, should default to local machine timezone.")
    private String timezone;
    private final static long serialVersionUID = -6836537185267313942L;

    /**
     * Time interval (ISO 8601 format) describing when the workflow starting state is active
     * 
     */
    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    /**
     * Time interval (ISO 8601 format) describing when the workflow starting state is active
     * 
     */
    @JsonProperty("interval")
    public void setInterval(String interval) {
        this.interval = interval;
    }

    public Schedule withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Schedule cron definition
     * 
     */
    @JsonProperty("cron")
    public Cron getCron() {
        return cron;
    }

    /**
     * Schedule cron definition
     * 
     */
    @JsonProperty("cron")
    public void setCron(Cron cron) {
        this.cron = cron;
    }

    public Schedule withCron(Cron cron) {
        this.cron = cron;
        return this;
    }

    /**
     * Timezone name used to evaluate the cron expression. Not used for interval as timezone can be specified there directly. If not specified, should default to local machine timezone.
     * 
     */
    @JsonProperty("timezone")
    public String getTimezone() {
        return timezone;
    }

    /**
     * Timezone name used to evaluate the cron expression. Not used for interval as timezone can be specified there directly. If not specified, should default to local machine timezone.
     * 
     */
    @JsonProperty("timezone")
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public Schedule withTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

}
