
package io.serverlessworkflow.api.retry;

import java.io.Serializable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Retry Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "delay",
    "maxDelay",
    "increment",
    "multiplier",
    "maxAttempts",
    "jitter"
})
public class RetryDefinition implements Serializable
{

    /**
     * Unique retry strategy name
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Unique retry strategy name")
    @Size(min = 1)
    @NotNull
    private String name;
    /**
     * Time delay between retry attempts (ISO 8601 duration format)
     * 
     */
    @JsonProperty("delay")
    @JsonPropertyDescription("Time delay between retry attempts (ISO 8601 duration format)")
    private String delay;
    /**
     * Maximum time delay between retry attempts (ISO 8601 duration format)
     * 
     */
    @JsonProperty("maxDelay")
    @JsonPropertyDescription("Maximum time delay between retry attempts (ISO 8601 duration format)")
    private String maxDelay;
    /**
     * Static value by which the delay increases during each attempt (ISO 8601 time format)
     * 
     */
    @JsonProperty("increment")
    @JsonPropertyDescription("Static value by which the delay increases during each attempt (ISO 8601 time format)")
    private String increment;
    /**
     * Multiplier value by which interval increases during each attempt (ISO 8601 time format)
     * 
     */
    @JsonProperty("multiplier")
    @JsonPropertyDescription("Multiplier value by which interval increases during each attempt (ISO 8601 time format)")
    private String multiplier;
    /**
     * Maximum number of retry attempts. Value of 0 means no retries are performed
     * (Required)
     * 
     */
    @JsonProperty("maxAttempts")
    @JsonPropertyDescription("Maximum number of retry attempts. Value of 0 means no retries are performed")
    @NotNull
    private String maxAttempts = "0";
    /**
     * Absolute maximum amount of random time added or subtracted from the delay between each retry (ISO 8601 duration format)
     * 
     */
    @JsonProperty("jitter")
    @JsonPropertyDescription("Absolute maximum amount of random time added or subtracted from the delay between each retry (ISO 8601 duration format)")
    @DecimalMin("0")
    @DecimalMax("1")
    private String jitter;
    private final static long serialVersionUID = 2618758715524494864L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RetryDefinition() {
    }

    /**
     * 
     * @param maxAttempts
     * @param name
     */
    public RetryDefinition(String name, String maxAttempts) {
        super();
        this.name = name;
        this.maxAttempts = maxAttempts;
    }

    /**
     * Unique retry strategy name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Unique retry strategy name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public RetryDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Time delay between retry attempts (ISO 8601 duration format)
     * 
     */
    @JsonProperty("delay")
    public String getDelay() {
        return delay;
    }

    /**
     * Time delay between retry attempts (ISO 8601 duration format)
     * 
     */
    @JsonProperty("delay")
    public void setDelay(String delay) {
        this.delay = delay;
    }

    public RetryDefinition withDelay(String delay) {
        this.delay = delay;
        return this;
    }

    /**
     * Maximum time delay between retry attempts (ISO 8601 duration format)
     * 
     */
    @JsonProperty("maxDelay")
    public String getMaxDelay() {
        return maxDelay;
    }

    /**
     * Maximum time delay between retry attempts (ISO 8601 duration format)
     * 
     */
    @JsonProperty("maxDelay")
    public void setMaxDelay(String maxDelay) {
        this.maxDelay = maxDelay;
    }

    public RetryDefinition withMaxDelay(String maxDelay) {
        this.maxDelay = maxDelay;
        return this;
    }

    /**
     * Static value by which the delay increases during each attempt (ISO 8601 time format)
     * 
     */
    @JsonProperty("increment")
    public String getIncrement() {
        return increment;
    }

    /**
     * Static value by which the delay increases during each attempt (ISO 8601 time format)
     * 
     */
    @JsonProperty("increment")
    public void setIncrement(String increment) {
        this.increment = increment;
    }

    public RetryDefinition withIncrement(String increment) {
        this.increment = increment;
        return this;
    }

    /**
     * Multiplier value by which interval increases during each attempt (ISO 8601 time format)
     * 
     */
    @JsonProperty("multiplier")
    public String getMultiplier() {
        return multiplier;
    }

    /**
     * Multiplier value by which interval increases during each attempt (ISO 8601 time format)
     * 
     */
    @JsonProperty("multiplier")
    public void setMultiplier(String multiplier) {
        this.multiplier = multiplier;
    }

    public RetryDefinition withMultiplier(String multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    /**
     * Maximum number of retry attempts. Value of 0 means no retries are performed
     * (Required)
     * 
     */
    @JsonProperty("maxAttempts")
    public String getMaxAttempts() {
        return maxAttempts;
    }

    /**
     * Maximum number of retry attempts. Value of 0 means no retries are performed
     * (Required)
     * 
     */
    @JsonProperty("maxAttempts")
    public void setMaxAttempts(String maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public RetryDefinition withMaxAttempts(String maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    /**
     * Absolute maximum amount of random time added or subtracted from the delay between each retry (ISO 8601 duration format)
     * 
     */
    @JsonProperty("jitter")
    public String getJitter() {
        return jitter;
    }

    /**
     * Absolute maximum amount of random time added or subtracted from the delay between each retry (ISO 8601 duration format)
     * 
     */
    @JsonProperty("jitter")
    public void setJitter(String jitter) {
        this.jitter = jitter;
    }

    public RetryDefinition withJitter(String jitter) {
        this.jitter = jitter;
        return this;
    }

}
