
package io.serverlessworkflow.api.repeat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "expression",
    "checkBefore",
    "max",
    "continueOnError",
    "stopOnEvents"
})
public class Repeat implements Serializable
{

    /**
     * Expression evaluated against SubFlow state data. SubFlow will repeat execution as long as this expression is true or until the max property count is reached
     * 
     */
    @JsonProperty("expression")
    @JsonPropertyDescription("Expression evaluated against SubFlow state data. SubFlow will repeat execution as long as this expression is true or until the max property count is reached")
    @Size(min = 1)
    private String expression;
    /**
     * If true, the expression is evaluated before each repeat execution, if false the expression is evaluated after each repeat execution
     * 
     */
    @JsonProperty("checkBefore")
    @JsonPropertyDescription("If true, the expression is evaluated before each repeat execution, if false the expression is evaluated after each repeat execution")
    private boolean checkBefore = true;
    /**
     * Sets the maximum amount of repeat executions
     * 
     */
    @JsonProperty("max")
    @JsonPropertyDescription("Sets the maximum amount of repeat executions")
    @DecimalMin("0")
    private int max;
    /**
     * If true, repeats executions in a case unhandled errors propagate from the sub-workflow to this state
     * 
     */
    @JsonProperty("continueOnError")
    @JsonPropertyDescription("If true, repeats executions in a case unhandled errors propagate from the sub-workflow to this state")
    private boolean continueOnError = false;
    /**
     * List referencing defined consumed workflow events. SubFlow will repeat execution until one of the defined events is consumed, or until the max property count is reached
     * 
     */
    @JsonProperty("stopOnEvents")
    @JsonPropertyDescription("List referencing defined consumed workflow events. SubFlow will repeat execution until one of the defined events is consumed, or until the max property count is reached")
    @Valid
    private List<String> stopOnEvents = new ArrayList<String>();
    private final static long serialVersionUID = 1851955639467650709L;

    /**
     * Expression evaluated against SubFlow state data. SubFlow will repeat execution as long as this expression is true or until the max property count is reached
     * 
     */
    @JsonProperty("expression")
    public String getExpression() {
        return expression;
    }

    /**
     * Expression evaluated against SubFlow state data. SubFlow will repeat execution as long as this expression is true or until the max property count is reached
     * 
     */
    @JsonProperty("expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Repeat withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * If true, the expression is evaluated before each repeat execution, if false the expression is evaluated after each repeat execution
     * 
     */
    @JsonProperty("checkBefore")
    public boolean isCheckBefore() {
        return checkBefore;
    }

    /**
     * If true, the expression is evaluated before each repeat execution, if false the expression is evaluated after each repeat execution
     * 
     */
    @JsonProperty("checkBefore")
    public void setCheckBefore(boolean checkBefore) {
        this.checkBefore = checkBefore;
    }

    public Repeat withCheckBefore(boolean checkBefore) {
        this.checkBefore = checkBefore;
        return this;
    }

    /**
     * Sets the maximum amount of repeat executions
     * 
     */
    @JsonProperty("max")
    public int getMax() {
        return max;
    }

    /**
     * Sets the maximum amount of repeat executions
     * 
     */
    @JsonProperty("max")
    public void setMax(int max) {
        this.max = max;
    }

    public Repeat withMax(int max) {
        this.max = max;
        return this;
    }

    /**
     * If true, repeats executions in a case unhandled errors propagate from the sub-workflow to this state
     * 
     */
    @JsonProperty("continueOnError")
    public boolean isContinueOnError() {
        return continueOnError;
    }

    /**
     * If true, repeats executions in a case unhandled errors propagate from the sub-workflow to this state
     * 
     */
    @JsonProperty("continueOnError")
    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public Repeat withContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    /**
     * List referencing defined consumed workflow events. SubFlow will repeat execution until one of the defined events is consumed, or until the max property count is reached
     * 
     */
    @JsonProperty("stopOnEvents")
    public List<String> getStopOnEvents() {
        return stopOnEvents;
    }

    /**
     * List referencing defined consumed workflow events. SubFlow will repeat execution until one of the defined events is consumed, or until the max property count is reached
     * 
     */
    @JsonProperty("stopOnEvents")
    public void setStopOnEvents(List<String> stopOnEvents) {
        this.stopOnEvents = stopOnEvents;
    }

    public Repeat withStopOnEvents(List<String> stopOnEvents) {
        this.stopOnEvents = stopOnEvents;
        return this;
    }

}
