
package io.serverlessworkflow.api.functions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "operation",
    "type",
    "authRef",
    "metadata"
})
public class FunctionDefinition implements Serializable
{

    /**
     * Function unique name
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Function unique name")
    @Size(min = 1)
    @NotNull
    private java.lang.String name;
    /**
     * If type is `rest`, <path_to_openapi_definition>#<operation_id>. If type is `rpc`, <path_to_grpc_proto_file>#<service_name>#<service_method>. If type is `expression`, defines the workflow expression.
     * 
     */
    @JsonProperty("operation")
    @JsonPropertyDescription("If type is `rest`, <path_to_openapi_definition>#<operation_id>. If type is `rpc`, <path_to_grpc_proto_file>#<service_name>#<service_method>. If type is `expression`, defines the workflow expression.")
    @Size(min = 1)
    private java.lang.String operation;
    /**
     * Defines the function type. Is either `rest`, `asyncapi, `rpc`, `graphql`, `odata`, `expression`, or `custom`. Default is `rest`
     * 
     */
    @JsonProperty("type")
    @JsonPropertyDescription("Defines the function type. Is either `rest`, `asyncapi, `rpc`, `graphql`, `odata`, `expression`, or `custom`. Default is `rest`")
    private FunctionDefinition.Type type = FunctionDefinition.Type.fromValue("rest");
    /**
     * References an auth definition name to be used to access to resource defined in the operation parameter
     * 
     */
    @JsonProperty("authRef")
    @JsonPropertyDescription("References an auth definition name to be used to access to resource defined in the operation parameter")
    @Size(min = 1)
    private java.lang.String authRef;
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    private final static long serialVersionUID = -8792630341762512097L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FunctionDefinition() {
    }

    /**
     * 
     * @param name
     */
    public FunctionDefinition(java.lang.String name) {
        super();
        this.name = name;
    }

    /**
     * Function unique name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Function unique name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public FunctionDefinition withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * If type is `rest`, <path_to_openapi_definition>#<operation_id>. If type is `rpc`, <path_to_grpc_proto_file>#<service_name>#<service_method>. If type is `expression`, defines the workflow expression.
     * 
     */
    @JsonProperty("operation")
    public java.lang.String getOperation() {
        return operation;
    }

    /**
     * If type is `rest`, <path_to_openapi_definition>#<operation_id>. If type is `rpc`, <path_to_grpc_proto_file>#<service_name>#<service_method>. If type is `expression`, defines the workflow expression.
     * 
     */
    @JsonProperty("operation")
    public void setOperation(java.lang.String operation) {
        this.operation = operation;
    }

    public FunctionDefinition withOperation(java.lang.String operation) {
        this.operation = operation;
        return this;
    }

    /**
     * Defines the function type. Is either `rest`, `asyncapi, `rpc`, `graphql`, `odata`, `expression`, or `custom`. Default is `rest`
     * 
     */
    @JsonProperty("type")
    public FunctionDefinition.Type getType() {
        return type;
    }

    /**
     * Defines the function type. Is either `rest`, `asyncapi, `rpc`, `graphql`, `odata`, `expression`, or `custom`. Default is `rest`
     * 
     */
    @JsonProperty("type")
    public void setType(FunctionDefinition.Type type) {
        this.type = type;
    }

    public FunctionDefinition withType(FunctionDefinition.Type type) {
        this.type = type;
        return this;
    }

    /**
     * References an auth definition name to be used to access to resource defined in the operation parameter
     * 
     */
    @JsonProperty("authRef")
    public java.lang.String getAuthRef() {
        return authRef;
    }

    /**
     * References an auth definition name to be used to access to resource defined in the operation parameter
     * 
     */
    @JsonProperty("authRef")
    public void setAuthRef(java.lang.String authRef) {
        this.authRef = authRef;
    }

    public FunctionDefinition withAuthRef(java.lang.String authRef) {
        this.authRef = authRef;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public FunctionDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public enum Type {

        REST("rest"),
        ASYNCAPI("asyncapi"),
        RPC("rpc"),
        GRAPHQL("graphql"),
        ODATA("odata"),
        EXPRESSION("expression"),
        CUSTOM("custom");
        private final java.lang.String value;
        private final static Map<java.lang.String, FunctionDefinition.Type> CONSTANTS = new HashMap<java.lang.String, FunctionDefinition.Type>();

        static {
            for (FunctionDefinition.Type c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Type(java.lang.String value) {
            this.value = value;
        }

        @Override
        public java.lang.String toString() {
            return this.value;
        }

        @JsonValue
        public java.lang.String value() {
            return this.value;
        }

        @JsonCreator
        public static FunctionDefinition.Type fromValue(java.lang.String value) {
            FunctionDefinition.Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
