
package io.serverlessworkflow.api.events;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * Event References
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "triggerEventRef",
    "resultEventRef",
    "resultEventTimeout",
    "data",
    "contextAttributes",
    "invoke"
})
public class EventRef implements Serializable
{

    /**
     * Reference to the unique name of a 'produced' event definition
     * (Required)
     * 
     */
    @JsonProperty("triggerEventRef")
    @JsonPropertyDescription("Reference to the unique name of a 'produced' event definition")
    @NotNull
    private java.lang.String triggerEventRef;
    /**
     * Reference to the unique name of a 'consumed' event definition
     * (Required)
     * 
     */
    @JsonProperty("resultEventRef")
    @JsonPropertyDescription("Reference to the unique name of a 'consumed' event definition")
    @NotNull
    private java.lang.String resultEventRef;
    /**
     * Maximum amount of time (ISO 8601 format) to wait for the result event. If not defined it should default to the actionExecutionTimeout
     * 
     */
    @JsonProperty("resultEventTimeout")
    @JsonPropertyDescription("Maximum amount of time (ISO 8601 format) to wait for the result event. If not defined it should default to the actionExecutionTimeout")
    private java.lang.String resultEventTimeout;
    /**
     * Expression which selects parts of the states data output to become the data of the produced event.
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("Expression which selects parts of the states data output to become the data of the produced event.")
    private java.lang.String data;
    /**
     * Add additional extension context attributes to the produced event
     * 
     */
    @JsonProperty("contextAttributes")
    @JsonPropertyDescription("Add additional extension context attributes to the produced event")
    @Valid
    private Map<String, String> contextAttributes;
    /**
     * Specifies if the function should be invoked sync or async. Default is sync.
     * 
     */
    @JsonProperty("invoke")
    @JsonPropertyDescription("Specifies if the function should be invoked sync or async. Default is sync.")
    private EventRef.Invoke invoke = EventRef.Invoke.fromValue("sync");
    private final static long serialVersionUID = 6021703727803798401L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventRef() {
    }

    /**
     * 
     * @param resultEventRef
     * @param triggerEventRef
     */
    public EventRef(java.lang.String triggerEventRef, java.lang.String resultEventRef) {
        super();
        this.triggerEventRef = triggerEventRef;
        this.resultEventRef = resultEventRef;
    }

    /**
     * Reference to the unique name of a 'produced' event definition
     * (Required)
     * 
     */
    @JsonProperty("triggerEventRef")
    public java.lang.String getTriggerEventRef() {
        return triggerEventRef;
    }

    /**
     * Reference to the unique name of a 'produced' event definition
     * (Required)
     * 
     */
    @JsonProperty("triggerEventRef")
    public void setTriggerEventRef(java.lang.String triggerEventRef) {
        this.triggerEventRef = triggerEventRef;
    }

    public EventRef withTriggerEventRef(java.lang.String triggerEventRef) {
        this.triggerEventRef = triggerEventRef;
        return this;
    }

    /**
     * Reference to the unique name of a 'consumed' event definition
     * (Required)
     * 
     */
    @JsonProperty("resultEventRef")
    public java.lang.String getResultEventRef() {
        return resultEventRef;
    }

    /**
     * Reference to the unique name of a 'consumed' event definition
     * (Required)
     * 
     */
    @JsonProperty("resultEventRef")
    public void setResultEventRef(java.lang.String resultEventRef) {
        this.resultEventRef = resultEventRef;
    }

    public EventRef withResultEventRef(java.lang.String resultEventRef) {
        this.resultEventRef = resultEventRef;
        return this;
    }

    /**
     * Maximum amount of time (ISO 8601 format) to wait for the result event. If not defined it should default to the actionExecutionTimeout
     * 
     */
    @JsonProperty("resultEventTimeout")
    public java.lang.String getResultEventTimeout() {
        return resultEventTimeout;
    }

    /**
     * Maximum amount of time (ISO 8601 format) to wait for the result event. If not defined it should default to the actionExecutionTimeout
     * 
     */
    @JsonProperty("resultEventTimeout")
    public void setResultEventTimeout(java.lang.String resultEventTimeout) {
        this.resultEventTimeout = resultEventTimeout;
    }

    public EventRef withResultEventTimeout(java.lang.String resultEventTimeout) {
        this.resultEventTimeout = resultEventTimeout;
        return this;
    }

    /**
     * Expression which selects parts of the states data output to become the data of the produced event.
     * 
     */
    @JsonProperty("data")
    public java.lang.String getData() {
        return data;
    }

    /**
     * Expression which selects parts of the states data output to become the data of the produced event.
     * 
     */
    @JsonProperty("data")
    public void setData(java.lang.String data) {
        this.data = data;
    }

    public EventRef withData(java.lang.String data) {
        this.data = data;
        return this;
    }

    /**
     * Add additional extension context attributes to the produced event
     * 
     */
    @JsonProperty("contextAttributes")
    public Map<String, String> getContextAttributes() {
        return contextAttributes;
    }

    /**
     * Add additional extension context attributes to the produced event
     * 
     */
    @JsonProperty("contextAttributes")
    public void setContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
    }

    public EventRef withContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
        return this;
    }

    /**
     * Specifies if the function should be invoked sync or async. Default is sync.
     * 
     */
    @JsonProperty("invoke")
    public EventRef.Invoke getInvoke() {
        return invoke;
    }

    /**
     * Specifies if the function should be invoked sync or async. Default is sync.
     * 
     */
    @JsonProperty("invoke")
    public void setInvoke(EventRef.Invoke invoke) {
        this.invoke = invoke;
    }

    public EventRef withInvoke(EventRef.Invoke invoke) {
        this.invoke = invoke;
        return this;
    }

    public enum Invoke {

        SYNC("sync"),
        ASYNC("async");
        private final java.lang.String value;
        private final static Map<java.lang.String, EventRef.Invoke> CONSTANTS = new HashMap<java.lang.String, EventRef.Invoke>();

        static {
            for (EventRef.Invoke c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Invoke(java.lang.String value) {
            this.value = value;
        }

        @Override
        public java.lang.String toString() {
            return this.value;
        }

        @JsonValue
        public java.lang.String value() {
            return this.value;
        }

        @JsonCreator
        public static EventRef.Invoke fromValue(java.lang.String value) {
            EventRef.Invoke constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
