
package io.serverlessworkflow.api.error;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "code",
    "description"
})
public class ErrorDefinition implements Serializable
{

    /**
     * Domain-specific error name
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Domain-specific error name")
    @Size(min = 1)
    @NotNull
    private String name;
    /**
     * Error code. Can be used in addition to the name to help runtimes resolve to technical errors/exceptions. Should not be defined if error is set to '*'
     * 
     */
    @JsonProperty("code")
    @JsonPropertyDescription("Error code. Can be used in addition to the name to help runtimes resolve to technical errors/exceptions. Should not be defined if error is set to '*'")
    @Size(min = 1)
    private String code;
    /**
     * Error description
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("Error description")
    private String description;
    private final static long serialVersionUID = -5051899689051060824L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ErrorDefinition() {
    }

    /**
     * 
     * @param name
     */
    public ErrorDefinition(String name) {
        super();
        this.name = name;
    }

    /**
     * Domain-specific error name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Domain-specific error name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ErrorDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Error code. Can be used in addition to the name to help runtimes resolve to technical errors/exceptions. Should not be defined if error is set to '*'
     * 
     */
    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    /**
     * Error code. Can be used in addition to the name to help runtimes resolve to technical errors/exceptions. Should not be defined if error is set to '*'
     * 
     */
    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ErrorDefinition withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Error description
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * Error description
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ErrorDefinition withDescription(String description) {
        this.description = description;
        return this;
    }

}
