
package io.serverlessworkflow.api.error;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.transitions.Transition;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "errorRef",
    "errorRefs",
    "transition",
    "end"
})
public class Error implements Serializable
{

    /**
     * Reference to a unique workflow error definition. Used of errorRefs is not used
     * 
     */
    @JsonProperty("errorRef")
    @JsonPropertyDescription("Reference to a unique workflow error definition. Used of errorRefs is not used")
    @Size(min = 1)
    private String errorRef;
    /**
     * References one or more workflow error definitions. Used if errorRef is not used
     * 
     */
    @JsonProperty("errorRefs")
    @JsonPropertyDescription("References one or more workflow error definitions. Used if errorRef is not used")
    @Size(min = 1)
    @Valid
    private List<String> errorRefs = new ArrayList<String>();
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    @Valid
    @NotNull
    private Transition transition;
    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    @JsonPropertyDescription("State end definition")
    @Valid
    private End end;
    private final static long serialVersionUID = -5942415987505171493L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Error() {
    }

    /**
     * 
     * @param transition
     */
    public Error(Transition transition) {
        super();
        this.transition = transition;
    }

    /**
     * Reference to a unique workflow error definition. Used of errorRefs is not used
     * 
     */
    @JsonProperty("errorRef")
    public String getErrorRef() {
        return errorRef;
    }

    /**
     * Reference to a unique workflow error definition. Used of errorRefs is not used
     * 
     */
    @JsonProperty("errorRef")
    public void setErrorRef(String errorRef) {
        this.errorRef = errorRef;
    }

    public Error withErrorRef(String errorRef) {
        this.errorRef = errorRef;
        return this;
    }

    /**
     * References one or more workflow error definitions. Used if errorRef is not used
     * 
     */
    @JsonProperty("errorRefs")
    public List<String> getErrorRefs() {
        return errorRefs;
    }

    /**
     * References one or more workflow error definitions. Used if errorRef is not used
     * 
     */
    @JsonProperty("errorRefs")
    public void setErrorRefs(List<String> errorRefs) {
        this.errorRefs = errorRefs;
    }

    public Error withErrorRefs(List<String> errorRefs) {
        this.errorRefs = errorRefs;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public Error withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public End getEnd() {
        return end;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public void setEnd(End end) {
        this.end = end;
    }

    public Error withEnd(End end) {
        this.end = end;
        return this;
    }

}
