
package io.serverlessworkflow.api.end;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.timeouts.WorkflowExecTimeout;


/**
 * End definition continue as
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "workflowId",
    "version",
    "data",
    "workflowExecTimeout"
})
public class ContinueAs implements Serializable
{

    /**
     * Unique id of the workflow to continue execution as
     * 
     */
    @JsonProperty("workflowId")
    @JsonPropertyDescription("Unique id of the workflow to continue execution as")
    private String workflowId;
    /**
     * Version of the workflow to continue execution as
     * 
     */
    @JsonProperty("version")
    @JsonPropertyDescription("Version of the workflow to continue execution as")
    @Size(min = 1)
    private String version;
    /**
     * Expression which selects parts of the states data output to become the workflow data input of continued execution
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("Expression which selects parts of the states data output to become the workflow data input of continued execution")
    private String data;
    @JsonProperty("workflowExecTimeout")
    @Valid
    private WorkflowExecTimeout workflowExecTimeout;
    private final static long serialVersionUID = 409131742862039472L;

    /**
     * Unique id of the workflow to continue execution as
     * 
     */
    @JsonProperty("workflowId")
    public String getWorkflowId() {
        return workflowId;
    }

    /**
     * Unique id of the workflow to continue execution as
     * 
     */
    @JsonProperty("workflowId")
    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public ContinueAs withWorkflowId(String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    /**
     * Version of the workflow to continue execution as
     * 
     */
    @JsonProperty("version")
    public String getVersion() {
        return version;
    }

    /**
     * Version of the workflow to continue execution as
     * 
     */
    @JsonProperty("version")
    public void setVersion(String version) {
        this.version = version;
    }

    public ContinueAs withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Expression which selects parts of the states data output to become the workflow data input of continued execution
     * 
     */
    @JsonProperty("data")
    public String getData() {
        return data;
    }

    /**
     * Expression which selects parts of the states data output to become the workflow data input of continued execution
     * 
     */
    @JsonProperty("data")
    public void setData(String data) {
        this.data = data;
    }

    public ContinueAs withData(String data) {
        this.data = data;
        return this;
    }

    @JsonProperty("workflowExecTimeout")
    public WorkflowExecTimeout getWorkflowExecTimeout() {
        return workflowExecTimeout;
    }

    @JsonProperty("workflowExecTimeout")
    public void setWorkflowExecTimeout(WorkflowExecTimeout workflowExecTimeout) {
        this.workflowExecTimeout = workflowExecTimeout;
    }

    public ContinueAs withWorkflowExecTimeout(WorkflowExecTimeout workflowExecTimeout) {
        this.workflowExecTimeout = workflowExecTimeout;
        return this;
    }

}
