
package io.serverlessworkflow.api.defaultdef;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * Switch state default condition definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "transition",
    "end"
})
public class DefaultConditionDefinition implements Serializable
{

    @JsonProperty("transition")
    @Valid
    private Transition transition;
    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    @JsonPropertyDescription("State end definition")
    @Valid
    private End end;
    private final static long serialVersionUID = 1330177899510029969L;

    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public DefaultConditionDefinition withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public End getEnd() {
        return end;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public void setEnd(End end) {
        this.end = end;
    }

    public DefaultConditionDefinition withEnd(End end) {
        this.end = end;
        return this;
    }

}
