
package io.serverlessworkflow.api.datainputschema;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Workflow data input schema
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "schema",
    "failOnValidationErrors"
})
public class DataInputSchema implements Serializable
{

    /**
     * URI of the JSON Schema used to validate the workflow data input
     * (Required)
     * 
     */
    @JsonProperty("schema")
    @JsonPropertyDescription("URI of the JSON Schema used to validate the workflow data input")
    @Size(min = 1)
    @NotNull
    private String schema;
    /**
     * Determines if workfow execution should continue if there are validation errors
     * (Required)
     * 
     */
    @JsonProperty("failOnValidationErrors")
    @JsonPropertyDescription("Determines if workfow execution should continue if there are validation errors")
    @NotNull
    private boolean failOnValidationErrors = true;
    private final static long serialVersionUID = -5239024246688233784L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataInputSchema() {
    }

    /**
     * 
     * @param schema
     * @param failOnValidationErrors
     */
    public DataInputSchema(String schema, boolean failOnValidationErrors) {
        super();
        this.schema = schema;
        this.failOnValidationErrors = failOnValidationErrors;
    }

    /**
     * URI of the JSON Schema used to validate the workflow data input
     * (Required)
     * 
     */
    @JsonProperty("schema")
    public String getSchema() {
        return schema;
    }

    /**
     * URI of the JSON Schema used to validate the workflow data input
     * (Required)
     * 
     */
    @JsonProperty("schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public DataInputSchema withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Determines if workfow execution should continue if there are validation errors
     * (Required)
     * 
     */
    @JsonProperty("failOnValidationErrors")
    public boolean isFailOnValidationErrors() {
        return failOnValidationErrors;
    }

    /**
     * Determines if workfow execution should continue if there are validation errors
     * (Required)
     * 
     */
    @JsonProperty("failOnValidationErrors")
    public void setFailOnValidationErrors(boolean failOnValidationErrors) {
        this.failOnValidationErrors = failOnValidationErrors;
    }

    public DataInputSchema withFailOnValidationErrors(boolean failOnValidationErrors) {
        this.failOnValidationErrors = failOnValidationErrors;
        return this;
    }

}
